/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesModel;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.MiscUtils;
import org.codehaus.mojo.versions.xml.DependencyUpdatesXmlReportRenderer;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="dependency-updates-report", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class DependencyUpdatesReportMojo
extends AbstractVersionsReport<DependencyUpdatesModel> {
    @Parameter(property="processDependencyManagement", defaultValue="true")
    protected boolean processDependencyManagement;
    @Parameter(property="processDependencyManagementTransitive", defaultValue="true")
    protected boolean processDependencyManagementTransitive;
    @Parameter(property="dependencyUpdatesReportFormats", defaultValue="html")
    protected String[] formats = new String[]{"html"};
    @Parameter(property="onlyProjectDependencies", defaultValue="false")
    protected boolean onlyProjectDependencies;
    @Parameter(property="onlyUpgradable", defaultValue="false")
    protected boolean onlyUpgradable;

    @Inject
    protected DependencyUpdatesReportMojo(I18N i18n, RepositorySystem repositorySystem, ArtifactResolver artifactResolver, ArtifactMetadataSource artifactMetadataSource, WagonManager wagonManager, ReportRendererFactory rendererFactory) {
        super(i18n, repositorySystem, artifactResolver, artifactMetadataSource, wagonManager, rendererFactory);
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        TreeSet<Dependency> dependencies = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        dependencies.addAll(this.getProject().getDependencies());
        TreeSet<Dependency> dependencyManagement = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        if (this.processDependencyManagement) {
            if (this.processDependencyManagementTransitive) {
                if (this.getProject().getDependencyManagement() != null && this.getProject().getDependencyManagement().getDependencies() != null) {
                    for (Dependency dep2 : this.getProject().getDependencyManagement().getDependencies()) {
                        this.getLog().debug((CharSequence)("Dpmg: " + dep2.getGroupId() + ":" + dep2.getArtifactId() + ":" + dep2.getVersion() + ":" + dep2.getType() + ":" + dep2.getScope()));
                    }
                    dependencyManagement.addAll(this.getProject().getDependencyManagement().getDependencies());
                }
            } else if (this.getProject().getOriginalModel().getDependencyManagement() != null && this.getProject().getOriginalModel().getDependencyManagement().getDependencies() != null) {
                for (Dependency dep2 : this.getProject().getOriginalModel().getDependencyManagement().getDependencies()) {
                    this.getLog().debug((CharSequence)("Original Dpmg: " + dep2.getGroupId() + ":" + dep2.getArtifactId() + ":" + dep2.getVersion() + ":" + dep2.getType() + ":" + dep2.getScope()));
                }
                dependencyManagement.addAll(this.getProject().getOriginalModel().getDependencyManagement().getDependencies());
            }
            if (!this.onlyProjectDependencies) {
                dependencies.removeIf(dep -> dependencyManagement.stream().anyMatch(dmDep -> this.match((Dependency)dep, (Dependency)dmDep)));
            } else {
                dependencyManagement.removeIf(dep -> dependencies.stream().noneMatch(dmDep -> this.match((Dependency)dep, (Dependency)dmDep)));
            }
        }
        try {
            Map<Dependency, Object> dependencyManagementUpdates;
            Map<Dependency, ArtifactVersions> dependencyUpdates = this.getHelper().lookupDependenciesUpdates(dependencies, false);
            Map<Object, Object> map = dependencyManagementUpdates = this.processDependencyManagement ? this.getHelper().lookupDependenciesUpdates(dependencyManagement, false) : Collections.emptyMap();
            if (this.onlyUpgradable) {
                dependencyUpdates = MiscUtils.filter(dependencyUpdates, e -> e.getVersions().length > 0);
                dependencyManagementUpdates = MiscUtils.filter(dependencyManagementUpdates, e -> e.getVersions().length > 0);
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Dependency versions:");
                dependencyUpdates.forEach((key, value) -> this.getLog().debug((CharSequence)(key.toString() + ": " + Arrays.stream(value.getVersions()).map(Object::toString).collect(Collectors.joining(", ")))));
                this.getLog().debug((CharSequence)"Dependency management versions:");
                dependencyManagementUpdates.forEach((key, value) -> this.getLog().debug((CharSequence)(key.toString() + ": " + Arrays.stream(value.getVersions()).map(Object::toString).collect(Collectors.joining(", ")))));
            }
            for (String format : this.formats) {
                DependencyUpdatesModel model = new DependencyUpdatesModel(dependencyUpdates, dependencyManagementUpdates);
                if ("html".equals(format)) {
                    this.rendererFactory.createReportRenderer(this.getOutputName(), sink, locale, model).render();
                    continue;
                }
                if (!"xml".equals(format)) continue;
                Path outputDir = Paths.get(this.getProject().getBuild().getDirectory(), new String[0]);
                if (!Files.exists(outputDir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(outputDir, new FileAttribute[0]);
                    }
                    catch (IOException e2) {
                        throw new MavenReportException("Could not create the output directory");
                    }
                }
                Path outputFile = outputDir.resolve(this.getOutputName() + ".xml");
                new DependencyUpdatesXmlReportRenderer(model, outputFile).render();
            }
        }
        catch (ArtifactMetadataRetrievalException e3) {
            throw new MavenReportException(e3.getMessage(), (Exception)((Object)e3));
        }
    }

    private boolean match(Dependency dep, Dependency dmDep) {
        return !(!dmDep.getGroupId().equals(dep.getGroupId()) || !dmDep.getArtifactId().equals(dep.getArtifactId()) || dmDep.getScope() != null && !dmDep.getScope().equals(dep.getScope()) || dmDep.getClassifier() != null && !dmDep.getClassifier().equals(dep.getClassifier()) || dep.getVersion() != null && dmDep.getVersion() != null && !dmDep.getVersion().equals(dep.getVersion()));
    }

    public String getOutputName() {
        return "dependency-updates-report";
    }
}

