/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.recording;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.mojo.versions.recording.ChangeRecorder;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ChangeRecorderXML
implements ChangeRecorder {
    public static final String CHANGES_NAMESPACE = "http://www.mojohaus.org/versions-maven-plugin/schema/updates/1.0";
    private final Document document;
    private final Element root;

    public static ChangeRecorder create() {
        try {
            DocumentBuilderFactory documentBuilders = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilders.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element root = document.createElementNS(CHANGES_NAMESPACE, "updates");
            document.appendChild(root);
            return new ChangeRecorderXML(document, root);
        }
        catch (ParserConfigurationException | DOMException e) {
            throw new IllegalStateException(e);
        }
    }

    private ChangeRecorderXML(Document document, Element root) {
        this.document = Objects.requireNonNull(document, "document");
        this.root = Objects.requireNonNull(root, "root");
    }

    @Override
    public final void recordUpdate(String kind, String groupId, String artifactId, String oldVersion, String newVersion) {
        Objects.requireNonNull(kind, "kind");
        Objects.requireNonNull(groupId, "groupId");
        Objects.requireNonNull(artifactId, "artifactId");
        Objects.requireNonNull(oldVersion, "oldVersion");
        Objects.requireNonNull(newVersion, "newVersion");
        Element update = this.document.createElementNS(CHANGES_NAMESPACE, "update");
        update.setAttribute("kind", kind);
        update.setAttribute("groupId", groupId);
        update.setAttribute("artifactId", artifactId);
        update.setAttribute("oldVersion", oldVersion);
        update.setAttribute("newVersion", newVersion);
        this.root.appendChild(update);
    }

    @Override
    public final void serialize(OutputStream outputStream) throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(this.document);
            transformer.transform(source, new StreamResult(outputStream));
            outputStream.flush();
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
    }
}

