/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.BuildFailureException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.ordering.MavenVersionComparator;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public class DisplayPluginUpdatesMojo
extends AbstractVersionsUpdaterMojo {
    private static final int WARN_PAD_SIZE = 65;
    private static final int INFO_PAD_SIZE = 68;
    private static final String FROM_SUPER_POM = "(from super-pom) ";
    private LifecycleExecutor lifecycleExecutor;
    private ModelInterpolator modelInterpolator;
    private PluginManager pluginManager;
    private RuntimeInformation runtimeInformation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getSuperPomPluginManagement() throws MojoExecutionException {
        if (new DefaultArtifactVersion("3.0").compareTo((Object)this.runtimeInformation.getApplicationVersion()) <= 0) {
            this.getLog().debug((CharSequence)"Using Maven 3.x strategy to determine superpom defined plugins");
            try {
                Method getPluginsBoundByDefaultToAllLifecycles = LifecycleExecutor.class.getMethod("getPluginsBoundByDefaultToAllLifecycles", String.class);
                Set plugins = (Set)getPluginsBoundByDefaultToAllLifecycles.invoke((Object)this.lifecycleExecutor, this.getProject().getPackaging());
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(plugins.size());
                Iterator i = plugins.iterator();
                while (i.hasNext()) {
                    Plugin plugin = (Plugin)i.next();
                    result.put(DisplayPluginUpdatesMojo.getPluginCoords(plugin), DisplayPluginUpdatesMojo.getPluginVersion(plugin));
                }
                URL superPom = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/maven/model/pom-4.0.0.xml");
                if (superPom != null) {
                    try {
                        XmlStreamReader reader = ReaderFactory.newXmlReader((URL)superPom);
                        try {
                            StringBuffer buf = new StringBuffer(IOUtil.toString((Reader)reader));
                            ModifiedPomXMLEventReader pom = this.newModifiedPomXER(buf);
                            Pattern pathRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
                            Stack<StackState> pathStack = new Stack<StackState>();
                            StackState curState = null;
                            while (pom.hasNext()) {
                                XMLEvent event = pom.nextEvent();
                                if (event.isStartDocument()) {
                                    curState = new StackState("");
                                    pathStack.clear();
                                    continue;
                                }
                                if (event.isStartElement()) {
                                    String elementName = event.asStartElement().getName().getLocalPart();
                                    if (curState != null && pathRegex.matcher(curState.path).matches()) {
                                        if ("groupId".equals(elementName)) {
                                            curState.groupId = pom.getElementText().trim();
                                            continue;
                                        }
                                        if ("artifactId".equals(elementName)) {
                                            curState.artifactId = pom.getElementText().trim();
                                            continue;
                                        }
                                        if ("version".equals(elementName)) {
                                            curState.version = pom.getElementText().trim();
                                            continue;
                                        }
                                    }
                                    pathStack.push(curState);
                                    curState = new StackState(curState.path + "/" + elementName);
                                    continue;
                                }
                                if (!event.isEndElement()) continue;
                                if (curState != null && pathRegex.matcher(curState.path).matches() && curState.artifactId != null) {
                                    Plugin plugin = new Plugin();
                                    plugin.setArtifactId(curState.artifactId);
                                    plugin.setGroupId(curState.groupId == null ? "org.apache.maven.plugins" : curState.groupId);
                                    plugin.setVersion(curState.version);
                                    if (!result.containsKey(DisplayPluginUpdatesMojo.getPluginCoords(plugin))) {
                                        result.put(DisplayPluginUpdatesMojo.getPluginCoords(plugin), DisplayPluginUpdatesMojo.getPluginVersion(plugin));
                                    }
                                }
                                curState = (StackState)pathStack.pop();
                            }
                        }
                        finally {
                            IOUtil.close((Reader)reader);
                        }
                    }
                    catch (IOException e) {
                    }
                    catch (XMLStreamException e) {
                        // empty catch block
                    }
                }
                return result;
            }
            catch (NoSuchMethodException e1) {
            }
            catch (InvocationTargetException e1) {
            }
            catch (IllegalAccessException e1) {
                // empty catch block
            }
        }
        this.getLog().debug((CharSequence)"Using Maven 2.x strategy to determine superpom defined plugins");
        HashMap superPomPluginManagement = new HashMap();
        try {
            MavenProject superProject = this.projectBuilder.buildStandaloneSuperProject(this.localRepository);
            superPomPluginManagement.putAll(this.getPluginManagement(superProject.getOriginalModel()));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Could not determine the super pom.xml", (Exception)((Object)e));
        }
        return superPomPluginManagement;
    }

    private Map getPluginManagement(Model model) {
        HashMap<String, String> pluginManagement = new HashMap<String, String>();
        try {
            Iterator j = model.getBuild().getPluginManagement().getPlugins().iterator();
            while (j.hasNext()) {
                Plugin plugin = (Plugin)j.next();
                String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                if (version == null) continue;
                pluginManagement.put(coord, version);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Iterator i = model.getProfiles().iterator();
            while (i.hasNext()) {
                Profile profile = (Profile)i.next();
                try {
                    Iterator j = profile.getBuild().getPluginManagement().getPlugins().iterator();
                    while (j.hasNext()) {
                        Plugin plugin = (Plugin)j.next();
                        String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                        String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                        if (version == null) continue;
                        pluginManagement.put(coord, version);
                    }
                }
                catch (NullPointerException e) {
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return pluginManagement;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean noExplicitMavenMinVersion;
        Set pluginsWithVersionsSpecified;
        try {
            pluginsWithVersionsSpecified = this.findPluginsWithVersionsSpecified(this.getProject());
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        Map superPomPluginManagement = this.getSuperPomPluginManagement();
        this.getLog().debug((CharSequence)("superPom plugins = " + superPomPluginManagement));
        HashMap parentPluginManagement = new HashMap();
        HashMap parentBuildPlugins = new HashMap();
        HashMap parentReportPlugins = new HashMap();
        List parents = this.getParentProjects(this.getProject());
        Iterator<Object> i = parents.iterator();
        while (i.hasNext()) {
            Model interpolatedModel;
            MavenProject parentProject = (MavenProject)i.next();
            this.getLog().debug((CharSequence)("Processing parent: " + parentProject.getGroupId() + ":" + parentProject.getArtifactId() + ":" + parentProject.getVersion() + " -> " + parentProject.getFile()));
            StringWriter writer = new StringWriter();
            boolean havePom = false;
            try {
                Model originalModel = parentProject.getOriginalModel();
                if (originalModel == null) {
                    this.getLog().warn((CharSequence)("project.getOriginalModel()==null for  " + parentProject.getGroupId() + ":" + parentProject.getArtifactId() + ":" + parentProject.getVersion() + " is null, substituting project.getModel()"));
                    originalModel = parentProject.getModel();
                }
                try {
                    new MavenXpp3Writer().write((Writer)writer, originalModel);
                    writer.close();
                    havePom = true;
                }
                catch (IOException e) {
                    // empty catch block
                }
                interpolatedModel = this.modelInterpolator.interpolate(originalModel, (Map)this.getProject().getProperties());
            }
            catch (ModelInterpolationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            if (havePom) {
                try {
                    Set withVersionSpecified = this.findPluginsWithVersionsSpecified(new StringBuffer(writer.toString()));
                    Map map = this.getPluginManagement(interpolatedModel);
                    map.keySet().retainAll(withVersionSpecified);
                    parentPluginManagement.putAll(map);
                    map = this.getBuildPlugins(interpolatedModel, true);
                    map.keySet().retainAll(withVersionSpecified);
                    parentPluginManagement.putAll(map);
                    map = this.getReportPlugins(interpolatedModel, true);
                    map.keySet().retainAll(withVersionSpecified);
                    parentPluginManagement.putAll(map);
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                catch (XMLStreamException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            parentPluginManagement.putAll(this.getPluginManagement(interpolatedModel));
            parentPluginManagement.putAll(this.getBuildPlugins(interpolatedModel, true));
            parentPluginManagement.putAll(this.getReportPlugins(interpolatedModel, true));
        }
        Set plugins = this.getProjectPlugins(superPomPluginManagement, parentPluginManagement, parentBuildPlugins, parentReportPlugins, pluginsWithVersionsSpecified);
        ArrayList<String> updates = new ArrayList<String>();
        ArrayList<String> lockdown = new ArrayList<String>();
        TreeMap upgrades = new TreeMap(new MavenVersionComparator());
        ArtifactVersion curMavenVersion = this.runtimeInformation.getApplicationVersion();
        DefaultArtifactVersion specMavenVersion = new DefaultArtifactVersion(this.getRequiredMavenVersion(this.getProject(), "2.0"));
        DefaultArtifactVersion minMavenVersion = null;
        boolean superPomDrivingMinVersion = false;
        i = plugins.iterator();
        while (i.hasNext()) {
            StringBuffer buf;
            String newVersion;
            Object artifactVersion;
            Artifact artifact;
            String effectiveVersion;
            String coords;
            String version;
            String artifactId;
            String groupId;
            block65: {
                VersionRange versionRange;
                Object plugin = i.next();
                groupId = DisplayPluginUpdatesMojo.getPluginGroupId(plugin);
                artifactId = DisplayPluginUpdatesMojo.getPluginArtifactId(plugin);
                version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                coords = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
                if (version == null) {
                    version = (String)parentPluginManagement.get(coords);
                }
                this.getLog().debug((CharSequence)("Checking " + coords + " for updates newer than " + version));
                effectiveVersion = version;
                boolean unspecified = version == null;
                try {
                    versionRange = unspecified ? VersionRange.createFromVersionSpec((String)"[0,)") : VersionRange.createFromVersionSpec((String)version);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new MojoExecutionException("Invalid version range specification: " + version, (Exception)((Object)e));
                }
                artifact = this.artifactFactory.createPluginArtifact(groupId, artifactId, versionRange);
                artifactVersion = null;
                try {
                    DefaultArtifactVersion requires;
                    MavenProject mavenProject;
                    Artifact probe;
                    ArtifactVersions artifactVersions = this.getHelper().lookupArtifactVersions(artifact, true);
                    ArtifactVersion[] newerVersions = artifactVersions.getVersions(Boolean.TRUE.equals(this.allowSnapshots));
                    DefaultArtifactVersion minRequires = null;
                    for (int j = newerVersions.length - 1; j >= 0; --j) {
                        probe = this.artifactFactory.createDependencyArtifact(groupId, artifactId, VersionRange.createFromVersion((String)newerVersions[j].toString()), "pom", null, "runtime");
                        try {
                            String upgradePluginKey;
                            this.getHelper().resolveArtifact(probe, true);
                            mavenProject = this.projectBuilder.buildFromRepository(probe, this.remotePluginRepositories, this.localRepository);
                            requires = new DefaultArtifactVersion(this.getRequiredMavenVersion(mavenProject, "2.0"));
                            if (specMavenVersion.compareTo((Object)requires) >= 0 && artifactVersion == null) {
                                artifactVersion = newerVersions[j];
                            }
                            if (effectiveVersion == null && curMavenVersion.compareTo((Object)requires) >= 0) {
                                effectiveVersion = newerVersions[j].toString();
                            }
                            if (artifactVersion != null && effectiveVersion != null) break;
                            if (minRequires != null && minRequires.compareTo((Object)requires) <= 0) continue;
                            LinkedHashMap<String, String> upgradePlugins = (LinkedHashMap<String, String>)upgrades.get(requires);
                            if (upgradePlugins == null) {
                                upgradePlugins = new LinkedHashMap<String, String>();
                                upgrades.put(requires, upgradePlugins);
                            }
                            if (!upgradePlugins.containsKey(upgradePluginKey = this.compactKey(groupId, artifactId))) {
                                upgradePlugins.put(upgradePluginKey, newerVersions[j].toString());
                            }
                            minRequires = requires;
                            continue;
                        }
                        catch (ArtifactResolutionException e) {
                            continue;
                        }
                        catch (ArtifactNotFoundException e) {
                            continue;
                        }
                        catch (ProjectBuildingException e) {
                            // empty catch block
                        }
                    }
                    if (effectiveVersion == null) break block65;
                    VersionRange currentVersionRange = VersionRange.createFromVersion((String)effectiveVersion);
                    probe = this.artifactFactory.createDependencyArtifact(groupId, artifactId, currentVersionRange, "pom", null, "runtime");
                    try {
                        this.getHelper().resolveArtifact(probe, true);
                        mavenProject = this.projectBuilder.buildFromRepository(probe, this.remotePluginRepositories, this.localRepository);
                        requires = new DefaultArtifactVersion(this.getRequiredMavenVersion(mavenProject, "2.0"));
                        if (minMavenVersion == null || minMavenVersion.compareTo((Object)requires) < 0) {
                            minMavenVersion = requires;
                        }
                    }
                    catch (ArtifactResolutionException e) {
                    }
                    catch (ArtifactNotFoundException e) {
                    }
                    catch (ProjectBuildingException e) {}
                }
                catch (ArtifactMetadataRetrievalException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            }
            if (version == null && pluginsWithVersionsSpecified.contains(coords)) {
                version = artifactVersion != null ? artifactVersion.toString() : null;
            }
            this.getLog().debug((CharSequence)("[" + coords + "].version=" + version));
            this.getLog().debug((CharSequence)("[" + coords + "].artifactVersion=" + artifactVersion));
            this.getLog().debug((CharSequence)("[" + coords + "].effectiveVersion=" + effectiveVersion));
            this.getLog().debug((CharSequence)("[" + coords + "].specified=" + pluginsWithVersionsSpecified.contains(coords)));
            if (version == null || !pluginsWithVersionsSpecified.contains(coords)) {
                version = (String)superPomPluginManagement.get(ArtifactUtils.versionlessKey((Artifact)artifact));
                this.getLog().debug((CharSequence)("[" + coords + "].superPom.version=" + version));
                newVersion = artifactVersion != null ? artifactVersion.toString() : (version != null ? version : (effectiveVersion != null ? effectiveVersion : "(unknown)"));
                buf = new StringBuffer(this.compactKey(groupId, artifactId));
                buf.append(' ');
                int padding = 65 - effectiveVersion.length() - (version != null ? FROM_SUPER_POM.length() : 0);
                while (buf.length() < padding) {
                    buf.append('.');
                }
                buf.append(' ');
                if (version != null) {
                    buf.append(FROM_SUPER_POM);
                    superPomDrivingMinVersion = true;
                }
                buf.append(effectiveVersion);
                lockdown.add(buf.toString());
            } else {
                newVersion = artifactVersion != null ? artifactVersion.toString() : null;
            }
            if (version == null || artifactVersion == null || newVersion == null || new DefaultArtifactVersion(effectiveVersion).compareTo((Object)new DefaultArtifactVersion(newVersion)) >= 0) continue;
            buf = new StringBuffer(this.compactKey(groupId, artifactId));
            buf.append(' ');
            int padding = 68 - version.length() - newVersion.length() - 4;
            while (buf.length() < padding) {
                buf.append('.');
            }
            buf.append(' ');
            buf.append(effectiveVersion);
            buf.append(" -> ");
            buf.append(newVersion);
            updates.add(buf.toString());
        }
        this.getLog().info((CharSequence)"");
        if (updates.isEmpty()) {
            this.getLog().info((CharSequence)"All plugins with a version specified are using the latest versions.");
        } else {
            this.getLog().info((CharSequence)"The following plugin updates are available:");
            i = updates.iterator();
            while (i.hasNext()) {
                this.getLog().info((CharSequence)("  " + i.next()));
            }
        }
        this.getLog().info((CharSequence)"");
        if (lockdown.isEmpty()) {
            this.getLog().info((CharSequence)"All plugins have a version specified.");
        } else {
            this.getLog().warn((CharSequence)"The following plugins do not have their version specified:");
            i = lockdown.iterator();
            while (i.hasNext()) {
                this.getLog().warn((CharSequence)("  " + i.next()));
            }
        }
        this.getLog().info((CharSequence)"");
        boolean noMavenMinVersion = this.getRequiredMavenVersion(this.getProject(), null) == null;
        boolean bl = noExplicitMavenMinVersion = this.getProject().getPrerequisites() == null || this.getProject().getPrerequisites().getMaven() == null;
        if (noMavenMinVersion) {
            this.getLog().warn((CharSequence)"Project does not define minimum Maven version, default is: 2.0");
        } else if (noExplicitMavenMinVersion) {
            this.getLog().info((CharSequence)("Project inherits minimum Maven version as: " + specMavenVersion));
        } else {
            DefaultArtifactVersion explicitMavenVersion = new DefaultArtifactVersion(this.getProject().getPrerequisites().getMaven());
            if (explicitMavenVersion.compareTo((Object)specMavenVersion) < 0) {
                this.getLog().error((CharSequence)("Project's effective minimum Maven (from parent) is: " + specMavenVersion));
                this.getLog().error((CharSequence)("Project defines minimum Maven version as: " + explicitMavenVersion));
            } else {
                this.getLog().info((CharSequence)("Project defines minimum Maven version as: " + specMavenVersion));
            }
        }
        this.getLog().info((CharSequence)("Plugins require minimum Maven version of: " + minMavenVersion));
        if (superPomDrivingMinVersion) {
            this.getLog().info((CharSequence)("Note: the super-pom from Maven " + curMavenVersion + " defines some of the plugin"));
            this.getLog().info((CharSequence)"      versions and may be influencing the plugins required minimum Maven");
            this.getLog().info((CharSequence)"      version.");
        }
        this.getLog().info((CharSequence)"");
        if ("maven-plugin".equals(this.getProject().getPackaging())) {
            if (noMavenMinVersion) {
                this.getLog().warn((CharSequence)"Project (which is a Maven Plugin) does not define required minimum version of Maven.");
                this.getLog().warn((CharSequence)"Update the pom.xml to contain");
                this.getLog().warn((CharSequence)"    <prerequisites>");
                this.getLog().warn((CharSequence)"      <maven><!-- minimum version of Maven that the plugin works with --></maven>");
                this.getLog().warn((CharSequence)"    </prerequisites>");
                this.getLog().warn((CharSequence)("To build this plugin you need at least Maven " + minMavenVersion));
                this.getLog().warn((CharSequence)"A Maven Enforcer rule can be used to enforce this if you have not already set one up");
            } else if (minMavenVersion != null && specMavenVersion.compareTo(minMavenVersion) < 0) {
                this.getLog().warn((CharSequence)("Project (which is a Maven Plugin) targets Maven " + specMavenVersion + " or newer"));
                this.getLog().warn((CharSequence)("but requires Maven " + minMavenVersion + " or newer to build."));
                this.getLog().warn((CharSequence)"This may or may not be a problem. A Maven Enforcer rule can help ");
                this.getLog().warn((CharSequence)"enforce that the correct version of Maven is used to build this plugin.");
            } else {
                this.getLog().info((CharSequence)"No plugins require a newer version of Maven than specified by the pom.");
            }
        } else if (noMavenMinVersion) {
            this.getLog().error((CharSequence)"Project does not define required minimum version of Maven.");
            this.getLog().error((CharSequence)"Update the pom.xml to contain");
            this.getLog().error((CharSequence)"    <prerequisites>");
            this.getLog().error((CharSequence)("      <maven>" + minMavenVersion + "</maven>"));
            this.getLog().error((CharSequence)"    </prerequisites>");
        } else if (minMavenVersion != null && specMavenVersion.compareTo(minMavenVersion) < 0) {
            this.getLog().error((CharSequence)"Project requires an incorrect minimum version of Maven.");
            this.getLog().error((CharSequence)("Either change plugin versions to those compatible with " + specMavenVersion));
            this.getLog().error((CharSequence)"or update the pom.xml to contain");
            this.getLog().error((CharSequence)"    <prerequisites>");
            this.getLog().error((CharSequence)("      <maven>" + minMavenVersion + "</maven>"));
            this.getLog().error((CharSequence)"    </prerequisites>");
        } else {
            this.getLog().info((CharSequence)"No plugins require a newer version of Maven than specified by the pom.");
        }
        i = upgrades.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry mavenUpgrade = (Map.Entry)i.next();
            ArtifactVersion mavenUpgradeVersion = (ArtifactVersion)mavenUpgrade.getKey();
            Map upgradePlugins = (Map)mavenUpgrade.getValue();
            if (upgradePlugins.isEmpty() || specMavenVersion.compareTo((Object)mavenUpgradeVersion) >= 0) continue;
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("Require Maven " + mavenUpgradeVersion + " to use the following plugin updates:"));
            Iterator j = upgradePlugins.entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry entry = j.next();
                StringBuffer buf = new StringBuffer("  ");
                buf.append(entry.getKey().toString());
                buf.append(' ');
                String s = entry.getValue().toString();
                int padding = 68 - s.length() + 2;
                while (buf.length() < padding) {
                    buf.append('.');
                }
                buf.append(' ');
                buf.append(s);
                this.getLog().info((CharSequence)buf.toString());
            }
        }
        this.getLog().info((CharSequence)"");
    }

    private String compactKey(String groupId, String artifactId) {
        if ("org.apache.maven.plugins".equals(groupId)) {
            return artifactId;
        }
        return groupId + ":" + artifactId;
    }

    private String getRequiredMavenVersion(MavenProject mavenProject, String defaultValue) {
        Object requiredMavenVersion = null;
        while (mavenProject != null) {
            String mavenVersion;
            Prerequisites prerequisites = mavenProject.getPrerequisites();
            String string = mavenVersion = prerequisites == null ? null : prerequisites.getMaven();
            if (mavenVersion != null) {
                DefaultArtifactVersion v = new DefaultArtifactVersion(mavenVersion);
                if (requiredMavenVersion == null || requiredMavenVersion.compareTo((Object)v) < 0) {
                    requiredMavenVersion = v;
                }
            }
            mavenProject = mavenProject.getParent();
        }
        return requiredMavenVersion == null ? defaultValue : requiredMavenVersion.toString();
    }

    private Set findPluginsWithVersionsSpecified(MavenProject project) throws IOException, XMLStreamException {
        return this.findPluginsWithVersionsSpecified(PomHelper.readXmlFile(project.getFile()));
    }

    private Set findPluginsWithVersionsSpecified(StringBuffer pomContents) throws IOException, XMLStreamException {
        HashSet<String> result = new HashSet<String>();
        ModifiedPomXMLEventReader pom = this.newModifiedPomXER(pomContents);
        Pattern pathRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
        Stack<StackState> pathStack = new Stack<StackState>();
        StackState curState = null;
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartDocument()) {
                curState = new StackState("");
                pathStack.clear();
                continue;
            }
            if (event.isStartElement()) {
                String elementName = event.asStartElement().getName().getLocalPart();
                if (curState != null && pathRegex.matcher(curState.path).matches()) {
                    if ("groupId".equals(elementName)) {
                        curState.groupId = pom.getElementText().trim();
                        continue;
                    }
                    if ("artifactId".equals(elementName)) {
                        curState.artifactId = pom.getElementText().trim();
                        continue;
                    }
                    if ("version".equals(elementName)) {
                        curState.version = pom.getElementText().trim();
                        continue;
                    }
                }
                pathStack.push(curState);
                curState = new StackState(curState.path + "/" + elementName);
                continue;
            }
            if (!event.isEndElement()) continue;
            if (curState != null && pathRegex.matcher(curState.path).matches() && curState.artifactId != null && curState.version != null) {
                if (curState.groupId == null) {
                    curState.groupId = "org.apache.maven.plugins";
                }
                result.add(curState.groupId + ":" + curState.artifactId);
            }
            curState = (StackState)pathStack.pop();
        }
        return result;
    }

    private Map getBuildPlugins(Model model, boolean onlyIncludeInherited) {
        HashMap<String, String> buildPlugins = new HashMap<String, String>();
        try {
            Iterator j = model.getBuild().getPlugins().iterator();
            while (j.hasNext()) {
                Object plugin = j.next();
                String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                buildPlugins.put(coord, version);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Iterator i = model.getProfiles().iterator();
            while (i.hasNext()) {
                Profile profile = (Profile)i.next();
                try {
                    Iterator j = profile.getBuild().getPlugins().iterator();
                    while (j.hasNext()) {
                        Object plugin = j.next();
                        String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                        String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                        if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                        buildPlugins.put(coord, version);
                    }
                }
                catch (NullPointerException e) {
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return buildPlugins;
    }

    private static boolean getPluginInherited(Object plugin) {
        return "true".equalsIgnoreCase(plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getInherited() : ((Plugin)plugin).getInherited());
    }

    private Map getLifecyclePlugins(MavenProject project) throws MojoExecutionException {
        HashMap<String, Plugin> lifecyclePlugins = new HashMap<String, Plugin>();
        try {
            Set plugins = this.getBoundPlugins(project, "clean,deploy,site");
            Iterator i = plugins.iterator();
            while (i.hasNext()) {
                Plugin plugin = (Plugin)i.next();
                lifecyclePlugins.put(DisplayPluginUpdatesMojo.getPluginCoords(plugin), plugin);
            }
        }
        catch (PluginNotFoundException e) {
            throw new MojoExecutionException("Could not find plugin", (Exception)((Object)e));
        }
        catch (LifecycleExecutionException e) {
            throw new MojoExecutionException("Could not determine lifecycle", (Exception)((Object)e));
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Could not determine lifecycles", (Exception)e);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return lifecyclePlugins;
    }

    private Set getBoundPlugins(MavenProject project, String thePhases) throws PluginNotFoundException, LifecycleExecutionException, IllegalAccessException {
        if (new DefaultArtifactVersion("3.0").compareTo((Object)this.runtimeInformation.getApplicationVersion()) <= 0) {
            this.getLog().debug((CharSequence)"Using Maven 3.0+ strategy to determine lifecycle defined plugins");
            try {
                Method getPluginsBoundByDefaultToAllLifecycles = LifecycleExecutor.class.getMethod("getPluginsBoundByDefaultToAllLifecycles", String.class);
                Set plugins = (Set)getPluginsBoundByDefaultToAllLifecycles.invoke((Object)this.lifecycleExecutor, project.getPackaging() == null ? "jar" : project.getPackaging());
                LinkedHashSet<Plugin> result = new LinkedHashSet<Plugin>(plugins.size());
                Iterator i = plugins.iterator();
                while (i.hasNext()) {
                    Plugin plugin = (Plugin)i.next();
                    Plugin dup = new Plugin();
                    dup.setGroupId(plugin.getGroupId());
                    dup.setArtifactId(plugin.getArtifactId());
                    result.add(dup);
                }
                return result;
            }
            catch (NoSuchMethodException e1) {
            }
            catch (InvocationTargetException e1) {
            }
            catch (IllegalAccessException e1) {
                // empty catch block
            }
        }
        List lifecycles = null;
        if (new DefaultArtifactVersion("2.0.10").compareTo((Object)this.runtimeInformation.getApplicationVersion()) <= 0) {
            this.getLog().debug((CharSequence)"Using Maven 2.0.10+ strategy to determine lifecycle defined plugins");
            try {
                Method getLifecycles = LifecycleExecutor.class.getMethod("getLifecycles", new Class[0]);
                lifecycles = (List)getLifecycles.invoke((Object)this.lifecycleExecutor, new Object[0]);
            }
            catch (NoSuchMethodException e1) {
            }
            catch (InvocationTargetException e1) {
            }
            catch (IllegalAccessException e1) {
                // empty catch block
            }
        }
        if (lifecycles == null) {
            this.getLog().debug((CharSequence)"Falling back to Maven 2.0.9 hack to determine lifecycle defined plugins");
            lifecycles = (List)ReflectionUtils.getValueIncludingSuperclasses((String)"lifecycles", (Object)this.lifecycleExecutor);
        }
        HashSet allPlugins = new HashSet();
        String[] lifecyclePhases = thePhases.split(",");
        for (int i = 0; i < lifecyclePhases.length; ++i) {
            String lifecyclePhase = lifecyclePhases[i];
            if (!StringUtils.isNotEmpty((String)lifecyclePhase)) continue;
            try {
                Lifecycle lifecycle = this.getLifecycleForPhase(lifecycles, lifecyclePhase);
                allPlugins.addAll(this.getAllPlugins(project, lifecycle));
                continue;
            }
            catch (BuildFailureException e) {
                // empty catch block
            }
        }
        return allPlugins;
    }

    private Lifecycle getLifecycleForPhase(List lifecycles, String phase) throws BuildFailureException, LifecycleExecutionException {
        Lifecycle lifecycle = (Lifecycle)this.getPhaseToLifecycleMap(lifecycles).get(phase);
        if (lifecycle == null) {
            throw new BuildFailureException("Unable to find lifecycle for phase '" + phase + "'");
        }
        return lifecycle;
    }

    private Set getAllPlugins(MavenProject project, Lifecycle lifecycle) throws PluginNotFoundException, LifecycleExecutionException {
        Plugin plugin;
        String[] tokens;
        String value;
        HashSet<Object> plugins = new HashSet<Object>();
        Map mappings = this.findMappingsForLifecycle(project, lifecycle);
        Iterator iter = mappings.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            value = (String)entry.getValue();
            tokens = value.split(":");
            plugin = new Plugin();
            plugin.setGroupId(tokens[0]);
            plugin.setArtifactId(tokens[1]);
            plugins.add(plugin);
        }
        List mojos = this.findOptionalMojosForLifecycle(project, lifecycle);
        iter = mojos.iterator();
        while (iter.hasNext()) {
            value = (String)((Object)iter.next());
            tokens = value.split(":");
            plugin = new Plugin();
            plugin.setGroupId(tokens[0]);
            plugin.setArtifactId(tokens[1]);
            plugins.add(plugin);
        }
        Iterator i = project.getBuildPlugins().iterator();
        while (i.hasNext()) {
            plugins.add(i.next());
        }
        return plugins;
    }

    private Map findMappingsForLifecycle(MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        Map defaultMappings;
        Map mappings;
        String packaging;
        block6: {
            packaging = project.getPackaging();
            mappings = null;
            LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, this.session.getSettings(), this.session.getLocalRepository());
            if (m != null) {
                mappings = m.getPhases(lifecycle.getId());
            }
            defaultMappings = lifecycle.getDefaultPhases();
            if (mappings == null) {
                try {
                    m = (LifecycleMapping)this.session.lookup(LifecycleMapping.ROLE, packaging);
                    mappings = m.getPhases(lifecycle.getId());
                }
                catch (ComponentLookupException e) {
                    if (defaultMappings != null) break block6;
                    throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "'.", (Throwable)e);
                }
            }
        }
        if (mappings == null) {
            if (defaultMappings == null) {
                throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "', and there is no default");
            }
            mappings = defaultMappings;
        }
        return mappings;
    }

    private List findOptionalMojosForLifecycle(MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        String packaging = project.getPackaging();
        List optionalMojos = null;
        LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, this.session.getSettings(), this.session.getLocalRepository());
        if (m != null) {
            optionalMojos = m.getOptionalMojos(lifecycle.getId());
        }
        if (optionalMojos == null) {
            try {
                m = (LifecycleMapping)this.session.lookup(LifecycleMapping.ROLE, packaging);
                optionalMojos = m.getOptionalMojos(lifecycle.getId());
            }
            catch (ComponentLookupException e) {
                this.getLog().debug((CharSequence)("Error looking up lifecycle mapping to retrieve optional mojos. Lifecycle ID: " + lifecycle.getId() + ". Error: " + e.getMessage()), (Throwable)e);
            }
        }
        if (optionalMojos == null) {
            optionalMojos = Collections.EMPTY_LIST;
        }
        return optionalMojos;
    }

    private Object findExtension(MavenProject project, String role, String roleHint, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        Object pluginComponent = null;
        Iterator i = project.getBuildPlugins().iterator();
        while (i.hasNext() && pluginComponent == null) {
            Plugin plugin = (Plugin)i.next();
            if (!plugin.isExtensions()) continue;
            this.verifyPlugin(plugin, project, settings, localRepository);
            try {
                pluginComponent = this.pluginManager.getPluginComponent(plugin, role, roleHint);
            }
            catch (ComponentLookupException e) {
                this.getLog().debug((CharSequence)"Unable to find the lifecycle component in the extension", (Throwable)e);
            }
            catch (PluginManagerException e) {
                throw new LifecycleExecutionException("Error getting extensions from the plugin '" + plugin.getKey() + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return pluginComponent;
    }

    private PluginDescriptor verifyPlugin(Plugin plugin, MavenProject project, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = this.pluginManager.verifyPlugin(plugin, project, settings, localRepository);
        }
        catch (PluginManagerException e) {
            throw new LifecycleExecutionException("Internal error in the plugin manager getting plugin '" + plugin.getKey() + "': " + e.getMessage(), (Throwable)e);
        }
        catch (PluginVersionResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidPluginException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ArtifactResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (PluginVersionNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        return pluginDescriptor;
    }

    private List getParentProjects(MavenProject project) throws MojoExecutionException {
        ArrayList<MavenProject> parents = new ArrayList<MavenProject>();
        while (project.getParent() != null) {
            project = project.getParent();
            parents.add(0, project);
        }
        return parents;
    }

    public Map getPhaseToLifecycleMap(List lifecycles) throws LifecycleExecutionException {
        HashMap<String, Lifecycle> phaseToLifecycleMap = new HashMap<String, Lifecycle>();
        Iterator i = lifecycles.iterator();
        while (i.hasNext()) {
            Lifecycle lifecycle = (Lifecycle)i.next();
            Iterator p = lifecycle.getPhases().iterator();
            while (p.hasNext()) {
                String phase = (String)p.next();
                if (phaseToLifecycleMap.containsKey(phase)) {
                    Lifecycle prevLifecycle = (Lifecycle)phaseToLifecycleMap.get(phase);
                    throw new LifecycleExecutionException("Phase '" + phase + "' is defined in more than one lifecycle: '" + lifecycle.getId() + "' and '" + prevLifecycle.getId() + "'");
                }
                phaseToLifecycleMap.put(phase, lifecycle);
            }
        }
        return phaseToLifecycleMap;
    }

    private Set getProjectPlugins(Map superPomPluginManagement, Map parentPluginManagement, Map parentBuildPlugins, Map parentReportPlugins, Set pluginsWithVersionsSpecified) throws MojoExecutionException {
        String parentVersion;
        Iterator i;
        Model originalModel;
        HashMap plugins = new HashMap();
        this.getLog().debug((CharSequence)"Building list of project plugins...");
        if (this.getLog().isDebugEnabled()) {
            StringWriter origModel = new StringWriter();
            try {
                origModel.write("Original model:\n");
                this.getProject().writeOriginalModel((Writer)origModel);
                this.getLog().debug((CharSequence)origModel.toString());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.debugVersionMap("super-pom version map", superPomPluginManagement);
        this.debugVersionMap("parent version map", parentPluginManagement);
        HashMap excludePluginManagement = new HashMap(superPomPluginManagement);
        excludePluginManagement.putAll(parentPluginManagement);
        this.debugVersionMap("aggregate version map", excludePluginManagement);
        excludePluginManagement.keySet().removeAll(pluginsWithVersionsSpecified);
        this.debugVersionMap("final aggregate version map", excludePluginManagement);
        try {
            originalModel = this.modelInterpolator.interpolate(this.getProject().getOriginalModel(), (Map)this.getProject().getProperties());
        }
        catch (ModelInterpolationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        try {
            this.addProjectPlugins(plugins, originalModel.getBuild().getPluginManagement().getPlugins(), excludePluginManagement);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.debugPluginMap("after adding local pluginManagement", plugins);
        try {
            ArrayList lifecyclePlugins = new ArrayList(this.getLifecyclePlugins(this.getProject()).values());
            i = lifecyclePlugins.iterator();
            while (i.hasNext()) {
                Object lifecyclePlugin = i.next();
                if (DisplayPluginUpdatesMojo.getPluginVersion(lifecyclePlugin) != null) {
                    i.remove();
                    continue;
                }
                parentVersion = (String)parentPluginManagement.get(DisplayPluginUpdatesMojo.getPluginCoords(lifecyclePlugin));
                if (parentVersion == null) continue;
                i.remove();
            }
            this.addProjectPlugins(plugins, lifecyclePlugins, parentPluginManagement);
            this.debugPluginMap("after adding lifecycle plugins", plugins);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            ArrayList buildPlugins = new ArrayList(originalModel.getBuild().getPlugins());
            i = buildPlugins.iterator();
            while (i.hasNext()) {
                Object buildPlugin = i.next();
                if (DisplayPluginUpdatesMojo.getPluginVersion(buildPlugin) != null || (parentVersion = (String)parentPluginManagement.get(DisplayPluginUpdatesMojo.getPluginCoords(buildPlugin))) == null) continue;
                i.remove();
            }
            this.addProjectPlugins(plugins, buildPlugins, parentBuildPlugins);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.debugPluginMap("after adding build plugins", plugins);
        try {
            ArrayList reportPlugins = new ArrayList(originalModel.getReporting().getPlugins());
            i = reportPlugins.iterator();
            while (i.hasNext()) {
                Object reportPlugin = i.next();
                if (DisplayPluginUpdatesMojo.getPluginVersion(reportPlugin) != null || (parentVersion = (String)parentPluginManagement.get(DisplayPluginUpdatesMojo.getPluginCoords(reportPlugin))) == null) continue;
                i.remove();
            }
            this.addProjectPlugins(plugins, reportPlugins, parentReportPlugins);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.debugPluginMap("after adding reporting plugins", plugins);
        Iterator i2 = originalModel.getProfiles().iterator();
        while (i2.hasNext()) {
            Profile profile = (Profile)i2.next();
            try {
                this.addProjectPlugins(plugins, profile.getBuild().getPluginManagement().getPlugins(), excludePluginManagement);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            this.debugPluginMap("after adding build pluginManagement for profile " + profile.getId(), plugins);
            try {
                this.addProjectPlugins(plugins, profile.getBuild().getPlugins(), parentBuildPlugins);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            this.debugPluginMap("after adding build plugins for profile " + profile.getId(), plugins);
            try {
                this.addProjectPlugins(plugins, profile.getReporting().getPlugins(), parentReportPlugins);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            this.debugPluginMap("after adding reporting plugins for profile " + profile.getId(), plugins);
        }
        TreeSet result = new TreeSet(new PluginComparator());
        result.addAll(plugins.values());
        return result;
    }

    private void addProjectPlugins(Map plugins, Collection projectPlugins, Map parentDefinitions) {
        Iterator j = projectPlugins.iterator();
        while (j.hasNext()) {
            Object plugin = j.next();
            String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
            String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
            String parentVersion = (String)parentDefinitions.get(coord);
            if (!(version != null || plugins.containsKey(coord) && DisplayPluginUpdatesMojo.getPluginVersion(plugins.get(coord)) != null || parentVersion == null)) {
                Plugin parentPlugin = new Plugin();
                parentPlugin.setGroupId(DisplayPluginUpdatesMojo.getPluginGroupId(plugin));
                parentPlugin.setArtifactId(DisplayPluginUpdatesMojo.getPluginArtifactId(plugin));
                parentPlugin.setVersion(parentVersion);
                plugins.put(coord, parentPlugin);
            } else if (!(parentVersion != null && parentVersion.equals(version) || plugins.containsKey(coord) && DisplayPluginUpdatesMojo.getPluginVersion(plugins.get(coord)) != null)) {
                plugins.put(coord, plugin);
            }
            if (plugins.containsKey(coord)) continue;
            plugins.put(coord, plugin);
        }
    }

    private void debugPluginMap(String description, Map plugins) {
        if (this.getLog().isDebugEnabled()) {
            TreeSet sorted = new TreeSet(new PluginComparator());
            sorted.addAll(plugins.values());
            StringBuffer buf = new StringBuffer(description);
            Iterator i = sorted.iterator();
            while (i.hasNext()) {
                Object plugin = i.next();
                buf.append("\n    ");
                buf.append(DisplayPluginUpdatesMojo.getPluginCoords(plugin));
                buf.append(":");
                buf.append(DisplayPluginUpdatesMojo.getPluginVersion(plugin));
            }
            this.getLog().debug((CharSequence)buf.toString());
        }
    }

    private void debugVersionMap(String description, Map plugins) {
        if (this.getLog().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(description);
            Iterator i = plugins.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry plugin = i.next();
                buf.append("\n    ");
                buf.append(plugin.getKey());
                buf.append(":");
                buf.append(plugin.getValue());
            }
            this.getLog().debug((CharSequence)buf.toString());
        }
    }

    private static String getPluginCoords(Object plugin) {
        return DisplayPluginUpdatesMojo.getPluginGroupId(plugin) + ":" + DisplayPluginUpdatesMojo.getPluginArtifactId(plugin);
    }

    private static String getPluginArtifactId(Object plugin) {
        return plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getArtifactId() : ((Plugin)plugin).getArtifactId();
    }

    private static String getPluginGroupId(Object plugin) {
        return plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getGroupId() : ((Plugin)plugin).getGroupId();
    }

    private static String getPluginVersion(Object plugin) {
        return plugin instanceof ReportPlugin ? ((ReportPlugin)plugin).getVersion() : ((Plugin)plugin).getVersion();
    }

    private Map getReportPlugins(Model model, boolean onlyIncludeInherited) {
        HashMap<String, String> reportPlugins = new HashMap<String, String>();
        try {
            Iterator j = model.getReporting().getPlugins().iterator();
            while (j.hasNext()) {
                Object plugin = j.next();
                String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                reportPlugins.put(coord, version);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Iterator i = model.getProfiles().iterator();
            while (i.hasNext()) {
                Profile profile = (Profile)i.next();
                try {
                    Iterator j = profile.getReporting().getPlugins().iterator();
                    while (j.hasNext()) {
                        Object plugin = j.next();
                        String coord = DisplayPluginUpdatesMojo.getPluginCoords(plugin);
                        String version = DisplayPluginUpdatesMojo.getPluginVersion(plugin);
                        if (version == null || onlyIncludeInherited && !DisplayPluginUpdatesMojo.getPluginInherited(plugin)) continue;
                        reportPlugins.put(coord, version);
                    }
                }
                catch (NullPointerException e) {
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return reportPlugins;
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
    }

    private static final class StackState {
        private final String path;
        private String groupId;
        private String artifactId;
        private String version;

        public StackState(String path) {
            this.path = path;
        }

        public String toString() {
            return this.path + "[groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + "]";
        }
    }
}

