/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.ordering.VersionComparator;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class UseLatestSnapshotsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    protected Boolean allowMajorUpdates;
    protected Boolean allowMinorUpdates;
    protected Boolean allowIncrementalUpdates;
    public final Pattern matchSnapshotRegex = Pattern.compile("^(.+)-((SNAPSHOT)|(\\d{8}\\.\\d{6}-\\d+))$");

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useLatestSnapshots(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.isProcessingDependencies()) {
                this.useLatestSnapshots(pom, this.getProject().getDependencies());
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void useLatestSnapshots(ModifiedPomXMLEventReader pom, Collection dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        int segment = this.determineUnchangedSegment(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates);
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            DefaultArtifactVersion lowerBound;
            Dependency dep = (Dependency)i.next();
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            Matcher versionMatcher = this.matchSnapshotRegex.matcher(version);
            if (versionMatcher.matches()) continue;
            this.getLog().debug((CharSequence)("Looking for latest snapshot of " + this.toString(dep)));
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            VersionComparator versionComparator = versions.getVersionComparator();
            if (segment + 1 > versionComparator.getSegmentCount((ArtifactVersion)(lowerBound = new DefaultArtifactVersion(version)))) {
                this.getLog().info((CharSequence)("Ignoring " + this.toString(dep) + " as the version number is too short"));
                continue;
            }
            ArtifactVersion upperBound = segment >= 0 ? versionComparator.incrementSegment((ArtifactVersion)lowerBound, segment) : null;
            this.getLog().info((CharSequence)("Upper bound: " + upperBound.toString()));
            ArtifactVersion[] newer = versions.getVersions((ArtifactVersion)lowerBound, upperBound, true, false, false);
            this.getLog().debug((CharSequence)("Candidate versions " + Arrays.asList(newer)));
            String latestVersion = null;
            for (int j = 0; j < newer.length; ++j) {
                String newVersion = newer[j].toString();
                if (!this.matchSnapshotRegex.matcher(newVersion).matches()) continue;
                latestVersion = newVersion;
            }
            if (latestVersion == null || !PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, latestVersion)) continue;
            this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + latestVersion));
        }
    }
}

