/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class UseLatestReleasesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    public final Pattern matchSnapshotRegex = Pattern.compile("^(.+)-((SNAPSHOT)|(\\d{8}\\.\\d{6}-\\d+))$");

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useLatestReleases(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.isProcessingDependencies()) {
                this.useLatestReleases(pom, this.getProject().getDependencies());
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void useLatestReleases(ModifiedPomXMLEventReader pom, Collection dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            Artifact artifact;
            Dependency dep = (Dependency)i.next();
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            Matcher versionMatcher = this.matchSnapshotRegex.matcher(version);
            if (versionMatcher.matches() || !this.isIncluded(artifact = this.toArtifact(dep))) continue;
            this.getLog().debug((CharSequence)("Looking for newer versions of " + this.toString(dep)));
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            ArtifactVersion[] newer = versions.getNewerVersions(version, false);
            if ((newer = this.filterVersionsWithIncludes(newer, artifact)).length <= 0) continue;
            String newVersion = newer[newer.length - 1].toString();
            if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, newVersion)) continue;
            this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + newVersion));
        }
    }

    private ArtifactVersion[] filterVersionsWithIncludes(ArtifactVersion[] newer, Artifact artifact) {
        ArrayList<ArtifactVersion> filteredNewer = new ArrayList<ArtifactVersion>(newer.length);
        for (int j = 0; j < newer.length; ++j) {
            ArtifactVersion artifactVersion = newer[j];
            DefaultArtifact artefactWithNewVersion = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), VersionRange.createFromVersion((String)artifactVersion.toString()), artifact.getScope(), artifact.getType(), null, (ArtifactHandler)new DefaultArtifactHandler(), false);
            if (!this.isIncluded((Artifact)artefactWithNewVersion)) continue;
            filteredNewer.add(artifactVersion);
        }
        return filteredNewer.toArray(new ArtifactVersion[filteredNewer.size()]);
    }
}

