/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="create-timestamp", defaultPhase=LifecyclePhase.INITIALIZE, requiresProject=true, threadSafe=true)
public class CreateTimestampMojo
extends AbstractMojo {
    @Parameter(property="maven.buildNumber.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List reactorProjects;
    @Parameter(property="maven.buildNumber.timestampPropertyName", defaultValue="timestamp")
    private String timestampPropertyName;
    @Parameter(property="maven.buildNumber.timestampFormat", defaultValue="")
    private String timestampFormat;

    public void execute() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        String timestampString = this.project.getProperties().getProperty(this.timestampPropertyName);
        if (timestampString != null) {
            this.getLog().debug((CharSequence)"Using previously created timestamp.");
            return;
        }
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        if (this.timestampFormat == null || this.timestampFormat.equals("")) {
            timestampString = String.valueOf(now.getTime());
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.timestampFormat);
            timestampString = dateFormat.format(now);
        }
        this.getLog().debug((CharSequence)("Storing timestamp property: " + this.timestampPropertyName + " " + timestampString));
        for (MavenProject nextProj : this.reactorProjects) {
            nextProj.getProperties().setProperty(this.timestampPropertyName, timestampString);
        }
    }
}

