/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xpp3;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.generator.java.javasource.JClass;
import org.codehaus.modello.generator.java.javasource.JField;
import org.codehaus.modello.generator.java.javasource.JMethod;
import org.codehaus.modello.generator.java.javasource.JParameter;
import org.codehaus.modello.generator.java.javasource.JSourceCode;
import org.codehaus.modello.generator.java.javasource.JSourceWriter;
import org.codehaus.modello.generator.java.javasource.JType;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.xpp3.AbstractXpp3Generator;
import org.codehaus.modello.plugins.xml.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;

public class Xpp3ReaderGenerator
extends AbstractXpp3Generator {
    public void generate(Model model, Properties properties) throws ModelloException {
        this.initialize(model, properties);
        try {
            this.generateXpp3Reader();
        }
        catch (IOException iOException) {
            throw new ModelloException("Exception while generating XPP3 Reader.", (Throwable)iOException);
        }
    }

    private void generateXpp3Reader() throws ModelloException, IOException {
        Model model = this.getModel();
        String string = this.isPackageWithVersion() ? model.getPackageName(true, this.getGeneratedVersion()) : model.getPackageName(false, null);
        string = String.valueOf(string) + ".io.xpp3";
        String string2 = string.replace('.', '/');
        String string3 = this.getFileName("Xpp3Reader");
        File file = new File(new File(this.getOutputDirectory(), string2), String.valueOf(string3) + ".java");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileWriter fileWriter = new FileWriter(file);
        JSourceWriter jSourceWriter = new JSourceWriter((Writer)fileWriter);
        JClass jClass = new JClass(string3);
        jClass.setPackageName(string);
        jClass.addImport("org.codehaus.plexus.util.xml.*");
        jClass.addImport("org.codehaus.plexus.util.xml.pull.*");
        jClass.addImport("java.io.Reader");
        jClass.addImport("java.util.ArrayList");
        jClass.addImport("java.util.List");
        this.addModelImports(jClass, null);
        JField jField = new JField(JType.Boolean, "addDefaultEntities");
        jField.setComment("If set the parser till be loaded with all single characters from the XHTML specification.\nThe entities used:\n<ul>\n<li>http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent</li>\n<li>http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent</li>\n<li>http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent</li>\n</ul>\n");
        jField.setInitString("true");
        jClass.addField(jField);
        JMethod jMethod = new JMethod(null, "setAddDefaultEntities");
        jMethod.addParameter(new JParameter(JType.Boolean, "addDefaultEntities"));
        jMethod.setSourceCode("this.addDefaultEntities = addDefaultEntities;");
        jMethod.setComment("Sets the state of the \"add default entities\" flag.");
        jClass.addMethod(jMethod);
        JMethod jMethod2 = new JMethod(JType.Boolean, "getAddDefaultEntities");
        jMethod.setComment("Returns the state of the \"add default entities\" flag.");
        jMethod2.setSourceCode("return addDefaultEntities;");
        jClass.addMethod(jMethod2);
        ModelClass modelClass = model.getClass(model.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        String string4 = AbstractModelloGenerator.uncapitalise((String)modelClass.getName());
        JMethod jMethod3 = new JMethod((JType)new JClass(modelClass.getName()), "read");
        jMethod3.addParameter(new JParameter((JType)new JClass("Reader"), "reader"));
        jMethod3.addException(new JClass("Exception"));
        JSourceCode jSourceCode = jMethod3.getSourceCode();
        jSourceCode.add("XmlPullParser parser = new MXParser();");
        jSourceCode.add("parser.setInput( reader );");
        jSourceCode.add("");
        this.writeParserInitialization(jSourceCode);
        jSourceCode.add("");
        jSourceCode.add("return parse" + modelClass.getName() + "( \"" + string4 + "\", parser );");
        jClass.addMethod(jMethod3);
        this.writeAllClassesParser(model, jClass);
        jClass.print(jSourceWriter);
        fileWriter.flush();
        fileWriter.close();
    }

    private void writeAllClassesParser(Model model, JClass jClass) {
        ModelClass modelClass = model.getClass(model.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        Iterator iterator = model.getClasses(this.getGeneratedVersion()).iterator();
        while (iterator.hasNext()) {
            ModelClass modelClass2 = (ModelClass)iterator.next();
            if (modelClass.getName().equals(modelClass2.getName())) {
                this.writeClassParser(modelClass2, jClass, true);
                continue;
            }
            this.writeClassParser(modelClass2, jClass, false);
        }
    }

    private void writeClassParser(ModelClass modelClass, JClass jClass, boolean bl) {
        XmlFieldMetadata xmlFieldMetadata;
        Object object;
        String string = modelClass.getName();
        String string2 = this.capitalise(string);
        String string3 = AbstractModelloGenerator.uncapitalise((String)string);
        String string4 = "if";
        JMethod jMethod = new JMethod((JType)new JClass(string), "parse" + string2);
        jMethod.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        jMethod.addParameter(new JParameter((JType)new JClass("XmlPullParser"), "parser"));
        jMethod.addException(new JClass("Exception"));
        jMethod.getModifiers().makePrivate();
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add(String.valueOf(string) + " " + string3 + " = new " + string + "();");
        if (bl) {
            jSourceCode.add("int eventType = parser.getEventType();");
            jSourceCode.add("while ( eventType != XmlPullParser.END_DOCUMENT )");
            jSourceCode.add("{");
            jSourceCode.indent();
            jSourceCode.add("if ( eventType == XmlPullParser.START_TAG )");
        } else {
            jSourceCode.add("while ( parser.nextTag() == XmlPullParser.START_TAG )");
        }
        jSourceCode.add("{");
        jSourceCode.indent();
        jSourceCode.add("if ( parser.getName().equals( tagName ) )");
        jSourceCode.add("{");
        jSourceCode.indent();
        Iterator iterator = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (iterator.hasNext()) {
            object = (ModelField)iterator.next();
            xmlFieldMetadata = (XmlFieldMetadata)object.getMetadata(XmlFieldMetadata.ID);
            if (!xmlFieldMetadata.isAttribute()) continue;
            this.writePrimitiveField((ModelField)object, object.getType(), string3, "set" + this.capitalise(object.getName()), jSourceCode);
        }
        jSourceCode.unindent();
        jSourceCode.add("}");
        object = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (object.hasNext()) {
            String string5;
            xmlFieldMetadata = (ModelField)object.next();
            XmlFieldMetadata xmlFieldMetadata2 = (XmlFieldMetadata)xmlFieldMetadata.getMetadata(XmlFieldMetadata.ID);
            if (xmlFieldMetadata2.isAttribute()) continue;
            String string6 = xmlFieldMetadata2.getTagName();
            if (string6 == null) {
                string6 = xmlFieldMetadata.getName();
            }
            if ((string5 = xmlFieldMetadata2.getAssociationTagName()) == null) {
                string5 = this.singular(string6);
            }
            boolean bl2 = "wrapped".equals(xmlFieldMetadata2.getListStyle());
            String string7 = this.capitalise(xmlFieldMetadata.getName());
            String string8 = this.singular(xmlFieldMetadata.getName());
            if (xmlFieldMetadata instanceof ModelAssociation) {
                ModelAssociation modelAssociation = (ModelAssociation)xmlFieldMetadata;
                String string9 = modelAssociation.getName();
                if ("1".equals(modelAssociation.getMultiplicity())) {
                    jSourceCode.add(String.valueOf(string4) + " ( parser.getName().equals( \"" + string6 + "\" ) )");
                    jSourceCode.add("{");
                    jSourceCode.indent();
                    jSourceCode.add(String.valueOf(string3) + ".set" + string7 + "( parse" + modelAssociation.getTo() + "( \"" + string6 + "\", parser ) );");
                    jSourceCode.unindent();
                    jSourceCode.add("}");
                } else {
                    String string10 = modelAssociation.getType();
                    if ("java.util.List".equals(string10) || "java.util.Set".equals(string10)) {
                        if (bl2) {
                            jSourceCode.add(String.valueOf(string4) + " ( parser.getName().equals( \"" + string6 + "\" ) )");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                            jSourceCode.add(String.valueOf(string10) + " " + string9 + " = " + modelAssociation.getDefaultValue() + ";");
                            jSourceCode.add(String.valueOf(string3) + ".set" + string7 + "( " + string9 + " );");
                            jSourceCode.add("while ( parser.nextTag() == XmlPullParser.START_TAG )");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                            jSourceCode.add("if ( parser.getName().equals( \"" + string5 + "\" ) )");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                        } else {
                            jSourceCode.add(String.valueOf(string4) + " ( parser.getName().equals( \"" + string5 + "\" ) )");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                            jSourceCode.add(String.valueOf(string10) + " " + string9 + " = " + string3 + ".get" + string7 + "();");
                            jSourceCode.add("if ( " + string9 + " == null )");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                            jSourceCode.add(String.valueOf(string9) + " = " + modelAssociation.getDefaultValue() + ";");
                            jSourceCode.add(String.valueOf(string3) + ".set" + string7 + "( " + string9 + " );");
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                        }
                        if (this.isClassInModel(modelAssociation.getTo(), modelClass.getModel())) {
                            jSourceCode.add(String.valueOf(string9) + ".add( parse" + modelAssociation.getTo() + "( \"" + string5 + "\", parser ) );");
                        } else {
                            this.writePrimitiveField((ModelField)modelAssociation, modelAssociation.getTo(), string9, "add", jSourceCode);
                        }
                        if (bl2) {
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                            jSourceCode.add("else");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                            jSourceCode.add("parser.nextText();");
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                        } else {
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                        }
                    } else {
                        jSourceCode.add(String.valueOf(string4) + " ( parser.getName().equals( \"" + string6 + "\" ) )");
                        jSourceCode.add("{");
                        jSourceCode.indent();
                        XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)modelAssociation.getAssociationMetadata(XmlAssociationMetadata.ID);
                        if ("explode".equals(xmlAssociationMetadata.getMapStyle())) {
                            jSourceCode.add("while ( parser.nextTag() == XmlPullParser.START_TAG )");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                            jSourceCode.add("if ( parser.getName().equals( \"" + string5 + "\" ) )");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                            jSourceCode.add("String key = null;");
                            jSourceCode.add("String value = null;");
                            jSourceCode.add("//" + xmlAssociationMetadata.getMapStyle() + " mode.");
                            jSourceCode.add("while ( parser.nextTag() == XmlPullParser.START_TAG )");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                            jSourceCode.add("if ( parser.getName().equals( \"key\" ) )");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                            jSourceCode.add("key = parser.nextText();");
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                            jSourceCode.add("else if ( parser.getName().equals( \"value\" ) )");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                            jSourceCode.add("value = parser.nextText()");
                            if (xmlFieldMetadata2.isTrim()) {
                                jSourceCode.add(".trim()");
                            }
                            jSourceCode.add(";");
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                            jSourceCode.add("else");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                            jSourceCode.add("parser.nextText();");
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                            jSourceCode.add(String.valueOf(string3) + ".add" + this.capitalise(string8) + "( key, value );");
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                            jSourceCode.add("parser.next();");
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                        } else {
                            jSourceCode.add("while ( parser.nextTag() == XmlPullParser.START_TAG )");
                            jSourceCode.add("{");
                            jSourceCode.indent();
                            jSourceCode.add("String key = parser.getName();");
                            jSourceCode.add("String value = parser.nextText()");
                            if (xmlFieldMetadata2.isTrim()) {
                                jSourceCode.add(".trim()");
                            }
                            jSourceCode.add(";");
                            jSourceCode.add(String.valueOf(string3) + ".add" + this.capitalise(string8) + "( key, value );");
                            jSourceCode.unindent();
                            jSourceCode.add("}");
                        }
                        jSourceCode.unindent();
                        jSourceCode.add("}");
                    }
                }
            } else {
                jSourceCode.add(String.valueOf(string4) + " ( parser.getName().equals( \"" + string6 + "\" ) )");
                jSourceCode.add("{");
                jSourceCode.indent();
                this.writePrimitiveField((ModelField)xmlFieldMetadata, xmlFieldMetadata.getType(), string3, "set" + this.capitalise(xmlFieldMetadata.getName()), jSourceCode);
                jSourceCode.unindent();
                jSourceCode.add("}");
            }
            string4 = "else if";
        }
        if (!bl) {
            if (modelClass.getFields(this.getGeneratedVersion()).size() > 0) {
                jSourceCode.add("else");
                jSourceCode.add("{");
                jSourceCode.indent();
                jSourceCode.add("parser.nextText();");
                jSourceCode.unindent();
                jSourceCode.add("}");
            }
        } else {
            jSourceCode.unindent();
            jSourceCode.add("}");
            jSourceCode.add("eventType = parser.next();");
        }
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("return " + string3 + ";");
        jClass.addMethod(jMethod);
    }

    private void writeParserInitialization(JSourceCode jSourceCode) {
        jSourceCode.add("if ( addDefaultEntities ) ");
        jSourceCode.add("{");
        jSourceCode.indent();
        jSourceCode.add("// ----------------------------------------------------------------------");
        jSourceCode.add("// Latin 1 entities");
        jSourceCode.add("// ----------------------------------------------------------------------");
        jSourceCode.add("");
        jSourceCode.add("parser.defineEntityReplacementText( \"nbsp\", \"\\u00a0\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"iexcl\", \"\\u00a1\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"cent\", \"\\u00a2\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"pound\", \"\\u00a3\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"curren\", \"\\u00a4\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"yen\", \"\\u00a5\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"brvbar\", \"\\u00a6\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sect\", \"\\u00a7\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"uml\", \"\\u00a8\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"copy\", \"\\u00a9\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ordf\", \"\\u00aa\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"laquo\", \"\\u00ab\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"not\", \"\\u00ac\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"shy\", \"\\u00ad\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"reg\", \"\\u00ae\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"macr\", \"\\u00af\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"deg\", \"\\u00b0\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"plusmn\", \"\\u00b1\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sup2\", \"\\u00b2\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sup3\", \"\\u00b3\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"acute\", \"\\u00b4\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"micro\", \"\\u00b5\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"para\", \"\\u00b6\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"middot\", \"\\u00b7\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"cedil\", \"\\u00b8\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sup1\", \"\\u00b9\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ordm\", \"\\u00ba\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"raquo\", \"\\u00bb\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"frac14\", \"\\u00bc\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"frac12\", \"\\u00bd\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"frac34\", \"\\u00be\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"iquest\", \"\\u00bf\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Agrave\", \"\\u00c0\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Aacute\", \"\\u00c1\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Acirc\", \"\\u00c2\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Atilde\", \"\\u00c3\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Auml\", \"\\u00c4\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Aring\", \"\\u00c5\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"AElig\", \"\\u00c6\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Ccedil\", \"\\u00c7\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Egrave\", \"\\u00c8\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Eacute\", \"\\u00c9\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Ecirc\", \"\\u00ca\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Euml\", \"\\u00cb\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Igrave\", \"\\u00cc\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Iacute\", \"\\u00cd\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Icirc\", \"\\u00ce\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Iuml\", \"\\u00cf\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ETH\", \"\\u00d0\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Ntilde\", \"\\u00d1\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Ograve\", \"\\u00d2\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Oacute\", \"\\u00d3\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Ocirc\", \"\\u00d4\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Otilde\", \"\\u00d5\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Ouml\", \"\\u00d6\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"times\", \"\\u00d7\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Oslash\", \"\\u00d8\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Ugrave\", \"\\u00d9\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Uacute\", \"\\u00da\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Ucirc\", \"\\u00db\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Uuml\", \"\\u00dc\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Yacute\", \"\\u00dd\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"THORN\", \"\\u00de\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"szlig\", \"\\u00df\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"agrave\", \"\\u00e0\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"aacute\", \"\\u00e1\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"acirc\", \"\\u00e2\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"atilde\", \"\\u00e3\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"auml\", \"\\u00e4\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"aring\", \"\\u00e5\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"aelig\", \"\\u00e6\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ccedil\", \"\\u00e7\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"egrave\", \"\\u00e8\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"eacute\", \"\\u00e9\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ecirc\", \"\\u00ea\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"euml\", \"\\u00eb\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"igrave\", \"\\u00ec\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"iacute\", \"\\u00ed\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"icirc\", \"\\u00ee\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"iuml\", \"\\u00ef\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"eth\", \"\\u00f0\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ntilde\", \"\\u00f1\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ograve\", \"\\u00f2\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"oacute\", \"\\u00f3\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ocirc\", \"\\u00f4\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"otilde\", \"\\u00f5\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ouml\", \"\\u00f6\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"divide\", \"\\u00f7\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"oslash\", \"\\u00f8\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ugrave\", \"\\u00f9\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"uacute\", \"\\u00fa\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ucirc\", \"\\u00fb\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"uuml\", \"\\u00fc\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"yacute\", \"\\u00fd\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"thorn\", \"\\u00fe\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"yuml\", \"\\u00ff\" ); ");
        jSourceCode.add("");
        jSourceCode.add("// ----------------------------------------------------------------------");
        jSourceCode.add("// Special entities");
        jSourceCode.add("// ----------------------------------------------------------------------");
        jSourceCode.add("");
        jSourceCode.add("parser.defineEntityReplacementText( \"OElig\", \"\\u0152\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"oelig\", \"\\u0153\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Scaron\", \"\\u0160\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"scaron\", \"\\u0161\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Yuml\", \"\\u0178\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"circ\", \"\\u02c6\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"tilde\", \"\\u02dc\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ensp\", \"\\u2002\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"emsp\", \"\\u2003\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"thinsp\", \"\\u2009\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"zwnj\", \"\\u200c\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"zwj\", \"\\u200d\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"lrm\", \"\\u200e\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"rlm\", \"\\u200f\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ndash\", \"\\u2013\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"mdash\", \"\\u2014\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"lsquo\", \"\\u2018\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"rsquo\", \"\\u2019\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sbquo\", \"\\u201a\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ldquo\", \"\\u201c\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"rdquo\", \"\\u201d\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"bdquo\", \"\\u201e\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"dagger\", \"\\u2020\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Dagger\", \"\\u2021\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"permil\", \"\\u2030\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"lsaquo\", \"\\u2039\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"rsaquo\", \"\\u203a\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"euro\", \"\\u20ac\" ); ");
        jSourceCode.add("");
        jSourceCode.add("// ----------------------------------------------------------------------");
        jSourceCode.add("// Symbol entities");
        jSourceCode.add("// ----------------------------------------------------------------------");
        jSourceCode.add("");
        jSourceCode.add("parser.defineEntityReplacementText( \"fnof\", \"\\u0192\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Alpha\", \"\\u0391\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Beta\", \"\\u0392\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Gamma\", \"\\u0393\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Delta\", \"\\u0394\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Epsilon\", \"\\u0395\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Zeta\", \"\\u0396\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Eta\", \"\\u0397\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Theta\", \"\\u0398\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Iota\", \"\\u0399\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Kappa\", \"\\u039a\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Lambda\", \"\\u039b\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Mu\", \"\\u039c\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Nu\", \"\\u039d\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Xi\", \"\\u039e\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Omicron\", \"\\u039f\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Pi\", \"\\u03a0\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Rho\", \"\\u03a1\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Sigma\", \"\\u03a3\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Tau\", \"\\u03a4\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Upsilon\", \"\\u03a5\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Phi\", \"\\u03a6\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Chi\", \"\\u03a7\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Psi\", \"\\u03a8\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Omega\", \"\\u03a9\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"alpha\", \"\\u03b1\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"beta\", \"\\u03b2\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"gamma\", \"\\u03b3\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"delta\", \"\\u03b4\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"epsilon\", \"\\u03b5\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"zeta\", \"\\u03b6\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"eta\", \"\\u03b7\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"theta\", \"\\u03b8\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"iota\", \"\\u03b9\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"kappa\", \"\\u03ba\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"lambda\", \"\\u03bb\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"mu\", \"\\u03bc\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"nu\", \"\\u03bd\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"xi\", \"\\u03be\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"omicron\", \"\\u03bf\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"pi\", \"\\u03c0\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"rho\", \"\\u03c1\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sigmaf\", \"\\u03c2\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sigma\", \"\\u03c3\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"tau\", \"\\u03c4\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"upsilon\", \"\\u03c5\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"phi\", \"\\u03c6\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"chi\", \"\\u03c7\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"psi\", \"\\u03c8\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"omega\", \"\\u03c9\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"thetasym\", \"\\u03d1\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"upsih\", \"\\u03d2\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"piv\", \"\\u03d6\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"bull\", \"\\u2022\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"hellip\", \"\\u2026\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"prime\", \"\\u2032\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"Prime\", \"\\u2033\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"oline\", \"\\u203e\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"frasl\", \"\\u2044\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"weierp\", \"\\u2118\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"image\", \"\\u2111\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"real\", \"\\u211c\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"trade\", \"\\u2122\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"alefsym\", \"\\u2135\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"larr\", \"\\u2190\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"uarr\", \"\\u2191\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"rarr\", \"\\u2192\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"darr\", \"\\u2193\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"harr\", \"\\u2194\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"crarr\", \"\\u21b5\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"lArr\", \"\\u21d0\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"uArr\", \"\\u21d1\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"rArr\", \"\\u21d2\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"dArr\", \"\\u21d3\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"hArr\", \"\\u21d4\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"forall\", \"\\u2200\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"part\", \"\\u2202\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"exist\", \"\\u2203\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"empty\", \"\\u2205\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"nabla\", \"\\u2207\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"isin\", \"\\u2208\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"notin\", \"\\u2209\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ni\", \"\\u220b\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"prod\", \"\\u220f\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sum\", \"\\u2211\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"minus\", \"\\u2212\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"lowast\", \"\\u2217\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"radic\", \"\\u221a\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"prop\", \"\\u221d\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"infin\", \"\\u221e\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ang\", \"\\u2220\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"and\", \"\\u2227\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"or\", \"\\u2228\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"cap\", \"\\u2229\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"cup\", \"\\u222a\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"int\", \"\\u222b\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"there4\", \"\\u2234\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sim\", \"\\u223c\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"cong\", \"\\u2245\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"asymp\", \"\\u2248\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ne\", \"\\u2260\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"equiv\", \"\\u2261\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"le\", \"\\u2264\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"ge\", \"\\u2265\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sub\", \"\\u2282\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sup\", \"\\u2283\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"nsub\", \"\\u2284\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sube\", \"\\u2286\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"supe\", \"\\u2287\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"oplus\", \"\\u2295\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"otimes\", \"\\u2297\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"perp\", \"\\u22a5\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"sdot\", \"\\u22c5\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"lceil\", \"\\u2308\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"rceil\", \"\\u2309\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"lfloor\", \"\\u230a\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"rfloor\", \"\\u230b\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"lang\", \"\\u2329\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"rang\", \"\\u232a\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"loz\", \"\\u25ca\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"spades\", \"\\u2660\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"clubs\", \"\\u2663\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"hearts\", \"\\u2665\" ); ");
        jSourceCode.add("parser.defineEntityReplacementText( \"diams\", \"\\u2666\" ); ");
        jSourceCode.add("");
        jSourceCode.unindent();
        jSourceCode.add("}");
    }

    private void writePrimitiveField(ModelField modelField, String string, String string2, String string3, JSourceCode jSourceCode) {
        String string4;
        XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)modelField.getMetadata(XmlFieldMetadata.ID);
        String string5 = xmlFieldMetadata.getTagName();
        if (string5 == null) {
            string5 = modelField.getName();
        }
        if (xmlFieldMetadata.isAttribute()) {
            string4 = "parser.getAttributeValue( \"\", \"" + string5 + "\" )";
        } else {
            string4 = "parser.nextText()";
            if (xmlFieldMetadata.isTrim()) {
                string4 = String.valueOf(string4) + ".trim()";
            }
        }
        if ("boolean".equals(string)) {
            jSourceCode.add(String.valueOf(string2) + "." + string3 + "( (new Boolean( " + string4 + " ) ).booleanValue() );");
        } else if ("char".equals(string)) {
            jSourceCode.add(String.valueOf(string2) + "." + string3 + "( (new Character( " + string4 + " ) ).charValue() );");
        } else if ("double".equals(string)) {
            jSourceCode.add(String.valueOf(string2) + "." + string3 + "( (new Double( " + string4 + " ) ).doubleValue() );");
        } else if ("float".equals(string)) {
            jSourceCode.add(String.valueOf(string2) + "." + string3 + "( (new Float( " + string4 + " ) ).floatValue() );");
        } else if ("int".equals(string)) {
            jSourceCode.add(String.valueOf(string2) + "." + string3 + "( (new Integer( " + string4 + " ) ).intValue() );");
        } else if ("long".equals(string)) {
            jSourceCode.add(String.valueOf(string2) + "." + string3 + "( (new Long( " + string4 + " ) ).longValue() );");
        } else if ("short".equals(string)) {
            jSourceCode.add(String.valueOf(string2) + "." + string3 + "( (new Short( " + string4 + " ) ).shortValue() );");
        } else if ("String".equals(string) || "Boolean".equals(string) || "Date".equals(string)) {
            jSourceCode.add(String.valueOf(string2) + "." + string3 + "( " + string4 + " );");
        } else if ("DOM".equals(string)) {
            jSourceCode.add(String.valueOf(string2) + "." + string3 + "( Xpp3DomBuilder.build( parser ) );");
        } else {
            throw new IllegalArgumentException("Unknown type: " + string);
        }
    }
}

