/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.Properties;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.cache.CacheItem;
import org.codehaus.httpcache4j.cache.DefaultCacheItem;
import org.codehaus.httpcache4j.payload.FilePayload;
import org.codehaus.httpcache4j.util.NumberUtils;

public class SerializableCacheItem
implements Serializable,
CacheItem {
    private static final long serialVersionUID = 7170431954380145524L;
    private transient CacheItem item;

    public SerializableCacheItem(CacheItem item) {
        this.item = item;
    }

    @Override
    public long getTTL() {
        return this.item.getTTL();
    }

    @Override
    public boolean isStale(LocalDateTime requestTime) {
        return this.item.isStale(requestTime);
    }

    @Override
    public long getAge(LocalDateTime dateTime) {
        return this.item.getAge(dateTime);
    }

    @Override
    public LocalDateTime getCachedTime() {
        return this.item.getCachedTime();
    }

    @Override
    public HTTPResponse getResponse() {
        return this.item.getResponse();
    }

    public Properties toProperties() {
        Properties object = new Properties();
        object.setProperty("cache-time", HeaderUtils.toHttpDate((String)"cache-time", (LocalDateTime)this.item.getCachedTime()).getValue());
        HTTPResponse response = this.item.getResponse();
        object.setProperty("status", String.valueOf(response.getStatus().getCode()));
        if (response.hasPayload()) {
            FilePayload payload = (FilePayload)response.getPayload().get();
            object.setProperty("file", payload.getFile().getAbsolutePath());
        }
        object.setProperty("headers", response.getHeaders().toString());
        return object;
    }

    public static CacheItem parse(Properties object) {
        Optional time = HeaderUtils.fromHttpDate((Header)new Header("cache-time", object.getProperty("cache-time")));
        Status status = Status.valueOf((int)NumberUtils.toInt((String)object.getProperty("status"), (int)200));
        Headers headers = Headers.parse((String)object.getProperty("headers"));
        Optional<Object> p = Optional.empty();
        if (object.containsKey("file")) {
            p = Optional.of(new FilePayload(new File(object.getProperty("file")), (MIMEType)headers.getContentType().get()));
        }
        return new DefaultCacheItem(new HTTPResponse(p, status, headers), (LocalDateTime)time.get());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.toProperties());
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Properties propValue = (Properties)in.readObject();
        this.item = SerializableCacheItem.parse(propValue);
    }
}

