/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.mutable.MutableHeaders;
import org.codehaus.httpcache4j.preference.Preference;

public final class Vary {
    private final Map<String, String> varyHeaders;

    public Vary() {
        this(Collections.emptyMap());
    }

    public Vary(Map<String, String> headers) {
        Preconditions.checkNotNull(headers, (Object)"Headers may not be null");
        TreeMap<String, String> h = new TreeMap<String, String>(new VaryComparator());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String value = this.normalizeValue(entry.getKey(), entry.getValue());
            h.put(entry.getKey(), value);
        }
        this.varyHeaders = Collections.unmodifiableMap(h);
    }

    public Vary(Headers headers) {
        TreeMap<String, String> h = new TreeMap<String, String>(new VaryComparator());
        for (Header header : headers) {
            String value = this.normalizeValue(header.getName(), header.getValue());
            h.put(header.getName(), value);
        }
        this.varyHeaders = Collections.unmodifiableMap(h);
    }

    private String normalizeValue(String name, String value) {
        if (name.toLowerCase().startsWith("accept")) {
            List parse = Preference.parse((Header)new Header(name, value), (Function)Functions.identity());
            value = Preference.toHeader((String)name, (List)parse, (Function)Functions.identity()).getValue();
        }
        return value;
    }

    public int size() {
        return this.varyHeaders.size();
    }

    public boolean isEmpty() {
        return this.varyHeaders.isEmpty();
    }

    public boolean matches(HTTPRequest request) {
        for (Map.Entry<String, String> varyEntry : this.varyHeaders.entrySet()) {
            Headers headers = request.getAllHeaders();
            List requestHeaderValue = headers.getHeaders(varyEntry.getKey());
            boolean valid = requestHeaderValue.isEmpty() ? varyEntry.getValue() == null : headers.getFirstHeader(varyEntry.getKey()).getValue().equals(varyEntry.getValue());
            if (valid) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        MutableHeaders headers = new MutableHeaders();
        for (Map.Entry<String, String> entry : this.varyHeaders.entrySet()) {
            headers.add(entry.getKey(), entry.getValue());
        }
        return headers.toHeaders().toString();
    }

    public Map<String, String> getVaryHeaders() {
        return this.varyHeaders;
    }

    public static Vary parse(String value) {
        Headers headers = Headers.parse((String)value);
        return new Vary(headers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vary vary = (Vary)o;
        return !(this.varyHeaders != null ? !this.varyHeaders.equals(vary.varyHeaders) : vary.varyHeaders != null);
    }

    public int hashCode() {
        return this.varyHeaders.hashCode();
    }

    public static class VaryComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 7826440288680033131L;
        private transient Collator collator = this.getCollator();

        private Collator getCollator() {
            if (this.collator == null) {
                this.collator = Collator.getInstance(Locale.UK);
            }
            return this.collator;
        }

        @Override
        public int compare(String one, String two) {
            return this.getCollator().compare(one, two);
        }
    }
}

