/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeletingFileFilter
implements FileFilter {
    private final List<File> knownFiles = new ArrayList<File>();

    public DeletingFileFilter() {
    }

    public DeletingFileFilter(List<File> knownFiles) {
        this.knownFiles.addAll((Collection)Preconditions.checkNotNull(knownFiles, (Object)"Known files may not be null"));
    }

    @Override
    public synchronized boolean accept(File pathname) {
        File[] files;
        if (!this.knownFiles.contains(pathname) && pathname.isFile()) {
            return !pathname.delete();
        }
        if (pathname.isDirectory() && ((files = pathname.listFiles(this)) == null || files.length == 0)) {
            return !pathname.delete();
        }
        return true;
    }
}

