/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.cache.CacheItem;
import org.codehaus.httpcache4j.cache.DefaultCacheItem;
import org.codehaus.httpcache4j.payload.FilePayload;
import org.codehaus.httpcache4j.util.NumberUtils;
import org.joda.time.DateTime;

public class SerializableCacheItem
implements Serializable,
CacheItem {
    private static final long serialVersionUID = 7170431954380145524L;
    private transient CacheItem item;

    public SerializableCacheItem(CacheItem item) {
        this.item = item;
    }

    @Override
    public int getTTL() {
        return this.item.getTTL();
    }

    @Override
    public boolean isStale(HTTPRequest request) {
        return this.item.isStale(request);
    }

    @Override
    public int getAge(HTTPRequest request) {
        return this.item.getAge(request);
    }

    @Override
    public DateTime getCachedTime() {
        return this.item.getCachedTime();
    }

    @Override
    public HTTPResponse getResponse() {
        return this.item.getResponse();
    }

    public Properties toProperties() {
        Properties object = new Properties();
        object.setProperty("cache-time", HeaderUtils.toHttpDate((String)"cache-time", (DateTime)this.item.getCachedTime()).getValue());
        HTTPResponse response = this.item.getResponse();
        object.setProperty("status", String.valueOf(response.getStatus().getCode()));
        if (response.hasPayload()) {
            FilePayload payload = (FilePayload)response.getPayload();
            object.setProperty("file", payload.getFile().getAbsolutePath());
        }
        object.setProperty("headers", response.getHeaders().toString());
        return object;
    }

    public static CacheItem parse(Properties object) {
        DateTime time = HeaderUtils.fromHttpDate((Header)new Header("cache-time", object.getProperty("cache-time")));
        Status status = Status.valueOf((int)NumberUtils.toInt((String)object.getProperty("status"), (int)200));
        Headers headers = Headers.parse((String)object.getProperty("headers"));
        FilePayload p = null;
        if (object.containsKey("file")) {
            p = new FilePayload(new File(object.getProperty("file")), MIMEType.valueOf((String)headers.getFirstHeaderValue("Content-Type")));
        }
        return new DefaultCacheItem(new HTTPResponse(p, status, headers), time);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.toProperties());
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Properties jsonValue = (Properties)in.readObject();
        this.item = SerializableCacheItem.parse(jsonValue);
    }
}

