/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.cache.Key;
import org.codehaus.httpcache4j.util.DeletingFileFilter;
import org.codehaus.httpcache4j.util.StorageUtil;

public final class FileManager
implements Serializable {
    private static final long serialVersionUID = -5273056780013227862L;
    private final File baseDirectory;

    public FileManager(File baseDirectory) {
        Validate.notNull((Object)baseDirectory, (String)"Base directory may not be null");
        this.baseDirectory = this.createFilesDirectory(baseDirectory);
    }

    private File createFilesDirectory(File baseDirectory) {
        File files = new File(baseDirectory, "files");
        StorageUtil.ensureDirectoryExists(files);
        return files;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File createFile(Key key, InputStream stream) throws IOException {
        File file = this.resolve(key);
        if (!file.getParentFile().exists()) {
            StorageUtil.ensureDirectoryExists(file.getParentFile());
        }
        FileOutputStream outputStream = FileUtils.openOutputStream((File)file);
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        if (file.length() == 0L) {
            file.delete();
            file = null;
        }
        if (file != null && !file.exists()) {
            throw new IOException(String.format("Failed to create File '%s' for Key: %s", file.getName(), key));
        }
        return file;
    }

    public synchronized void clear() {
        this.baseDirectory.listFiles(new DeletingFileFilter());
    }

    public synchronized void remove(Key key) {
        File resolved = this.resolve(key);
        if (resolved.delete() && this.directoryIsEmpty(resolved.getParentFile())) {
            resolved.getParentFile().delete();
        }
    }

    private boolean directoryIsEmpty(File directory) {
        String[] list;
        return directory.isDirectory() && ((list = directory.list()) == null || list.length == 0);
    }

    public synchronized File resolve(Key key) {
        String uriHex = DigestUtils.md5Hex((String)key.getURI().toString());
        String vary = key.getVary().isEmpty() ? "default" : DigestUtils.md5Hex((String)key.getVary().toString());
        File uriFolder = new File(this.baseDirectory, uriHex);
        return new File(uriFolder, vary);
    }
}

