/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public class CacheItem
implements Serializable {
    private static final long serialVersionUID = 5891522215450656044L;
    private final DateTime cachedTime;
    private final HTTPResponse response;
    private final int ttl;

    public CacheItem(HTTPResponse response) {
        this(response, new DateTime());
    }

    public CacheItem(HTTPResponse response, DateTime cachedTime) {
        Validate.notNull((Object)response, (String)"Response may not be null");
        Validate.notNull((Object)cachedTime, (String)"CacheTime may not be null");
        this.response = response;
        this.cachedTime = cachedTime;
        this.ttl = CacheItem.getTTL(response, 0);
    }

    public boolean isStale() {
        if (this.response.hasPayload() && !this.response.getPayload().isAvailable()) {
            return true;
        }
        return this.ttl - this.getAge() <= 0;
    }

    public int getAge() {
        return Seconds.secondsBetween((ReadableInstant)this.cachedTime, (ReadableInstant)new DateTime()).getSeconds();
    }

    public static int getTTL(HTTPResponse response, int defaultTTLinSeconds) {
        DateTime date;
        DateTime expiryDate;
        int maxAge;
        Header ccHeader;
        Map directives;
        String maxAgeDirective;
        Headers headers = response.getHeaders();
        if (headers.hasHeader("Cache-Control") && (maxAgeDirective = (String)(directives = (ccHeader = headers.getFirstHeader("Cache-Control")).getDirectives()).get("max-age")) != null && (maxAge = NumberUtils.toInt((String)maxAgeDirective, (int)-1)) > 0) {
            return maxAge;
        }
        if (headers.hasHeader("Expires") && (expiryDate = HeaderUtils.fromHttpDate((Header)headers.getFirstHeader("Expires"))) != null && (date = HeaderUtils.fromHttpDate((Header)headers.getFirstHeader("Date"))) != null && date.isBefore((ReadableInstant)expiryDate)) {
            return Seconds.secondsBetween((ReadableInstant)date, (ReadableInstant)expiryDate).getSeconds();
        }
        return defaultTTLinSeconds;
    }

    public DateTime getCachedTime() {
        return this.cachedTime;
    }

    public HTTPResponse getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheItem cacheItem = (CacheItem)o;
        if (this.cachedTime != null ? !this.cachedTime.equals((Object)cacheItem.cachedTime) : cacheItem.cachedTime != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals((Object)cacheItem.response) : cacheItem.response != null);
    }

    public int hashCode() {
        int result = this.cachedTime != null ? this.cachedTime.hashCode() : 0;
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        return result;
    }
}

