/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.HTTPRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Vary
implements Serializable {
    private static final long serialVersionUID = -5275022740812240365L;
    private final Map<String, String> varyHeaders;

    public Vary() {
        this(Collections.emptyMap());
    }

    public Vary(Map<String, String> headers) {
        Validate.notNull(headers, (String)"Headers may not be null");
        this.varyHeaders = Collections.unmodifiableMap(new LinkedHashMap<String, String>(headers));
    }

    public int size() {
        return this.varyHeaders.size();
    }

    public boolean isEmpty() {
        return this.varyHeaders.isEmpty();
    }

    public boolean matches(HTTPRequest request) {
        for (Map.Entry<String, String> varyEntry : this.varyHeaders.entrySet()) {
            List requestHeaderValue = request.getHeaders().getHeaders(varyEntry.getKey());
            boolean valid = requestHeaderValue == null ? varyEntry.getValue() == null : request.getHeaders().getFirstHeader(varyEntry.getKey()).getValue().equals(varyEntry.getValue());
            if (valid) continue;
            return false;
        }
        return true;
    }

    public Map<String, String> getVaryHeaders() {
        return this.varyHeaders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vary vary = (Vary)o;
        return !(this.varyHeaders != null ? !((Object)this.varyHeaders).equals(vary.varyHeaders) : vary.varyHeaders != null);
    }

    public int hashCode() {
        return ((Object)this.varyHeaders).hashCode();
    }
}

