/*
 * Decompiled with CFR 0.152.
 */
package org.escenic.http.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.escenic.http.Representation;
import org.escenic.http.servlet.AbstractEsiFilter;

public class ETagFilter
extends AbstractEsiFilter {
    public void doFilterImpl(HttpServletRequest pRequest, HttpServletResponse pResponse, FilterChain pChain, AbstractEsiFilter.PathElement pPath, Representation pRepresentation) throws IOException, ServletException {
        String ifMatch;
        if (pRepresentation != null) {
            String ifNoneMatch;
            if (pRequest.getMethod().equals("GET") || pRequest.getMethod().equals("HEAD")) {
                pResponse.setHeader("ETag", "\"" + pRepresentation.getVersionString() + "\"");
            }
            if ((ifNoneMatch = pRequest.getHeader("If-None-Match")) != null && ifNoneMatch.matches(".*\"" + pRepresentation.getVersionString() + "\".*")) {
                pResponse.setStatus(304);
                return;
            }
        }
        if ((ifMatch = pRequest.getHeader("If-Match")) != null) {
            if (ifMatch.equals("*")) {
                if (pRepresentation != null) {
                    pResponse.sendError(412, "The resource exists already");
                    return;
                }
            } else if (pRepresentation != null && !ifMatch.matches(".*\"" + pRepresentation.getVersionString() + "\".*")) {
                pResponse.sendError(412);
                return;
            }
        }
        pChain.doFilter((ServletRequest)pRequest, (ServletResponse)pResponse);
    }
}

