/*
 * Decompiled with CFR 0.152.
 */
package org.escenic.http.servlet;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.escenic.http.Representation;
import org.escenic.http.servlet.AbstractEsiFilter;

public class BasicAuthFilter
extends AbstractEsiFilter {
    private static final String BASIC = "Basic ";
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public void doFilterImpl(HttpServletRequest pRequest, HttpServletResponse pResponse, FilterChain pChain, AbstractEsiFilter.PathElement pPath, Representation pRepresentation) throws IOException, ServletException {
        String authorization;
        Map<String, String> parameters = pPath.getParameters();
        String user = parameters.get("u");
        String pass = parameters.get("p");
        boolean sendAuth = true;
        if (StringUtils.isNotBlank((String)user) && StringUtils.isNotBlank((String)pass) && StringUtils.isNotBlank((String)(authorization = pRequest.getHeader("Authorization"))) && authorization.indexOf(BASIC) != -1) {
            authorization = authorization.substring(BASIC.length()).trim();
            String encoded = new String(Base64.encodeBase64((byte[])(user + ":" + pass).getBytes()));
            if (encoded.equals(authorization)) {
                sendAuth = false;
                pChain.doFilter((ServletRequest)pRequest, (ServletResponse)pResponse);
            }
        }
        if (sendAuth) {
            this.sendAuthorization(pResponse);
        }
    }

    private void sendAuthorization(HttpServletResponse pResponse) {
        pResponse.addHeader("WWW-Authenticate", "Basic realm=\"TEST\"");
        pResponse.setStatus(401);
    }
}

