/*
 * Decompiled with CFR 0.152.
 */
package org.escenic.http.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.escenic.http.Representation;
import org.escenic.http.SimpleRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEsiFilter
implements Filter {
    protected FilterConfig mFilterConfig;
    private String mPath;

    public void init(FilterConfig pFilterConfig) throws ServletException {
        this.mFilterConfig = pFilterConfig;
        this.mPath = this.mFilterConfig.getInitParameter("path");
    }

    public void doFilter(ServletRequest pRequest, ServletResponse pResponse, FilterChain pChain) throws IOException, ServletException {
        if (!(pRequest instanceof HttpServletRequest)) {
            throw new ServletException("Not a HTTP container");
        }
        HttpServletRequest request = (HttpServletRequest)pRequest;
        HttpServletResponse response = (HttpServletResponse)pResponse;
        Map<String, PathElement> paths = AbstractEsiFilter.getPaths(request);
        PathElement path = paths.get(this.mPath);
        if (this.mPath != null && path == null) {
            pChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Representation representation = this.getRepresentation(request);
        this.mFilterConfig.getServletContext().log("In Filter: " + this.mFilterConfig.getFilterName());
        this.doFilterImpl(request, response, pChain, path, representation);
    }

    protected Representation getRepresentation(HttpServletRequest pRequest) {
        return SimpleRepresentation.get(AbstractEsiFilter.getFileName(pRequest));
    }

    public abstract void doFilterImpl(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3, PathElement var4, Representation var5) throws IOException, ServletException;

    public void destroy() {
    }

    public static Map<String, PathElement> getPaths(HttpServletRequest pRequest) {
        HashMap<String, PathElement> paths = (HashMap<String, PathElement>)pRequest.getAttribute(AbstractEsiFilter.class.getName() + ".PATH");
        if (paths == null) {
            paths = new HashMap<String, PathElement>();
            String path = AbstractEsiFilter.calculatePath(pRequest);
            for (String p : path.split("/")) {
                PathElement element = new PathElement(p);
                if (element.getName() == null || element.getName().equals("")) continue;
                paths.put(element.getName(), element);
            }
        }
        return paths;
    }

    private static String calculatePath(HttpServletRequest pRequest) {
        String pathInfo;
        String path = pRequest.getServletPath();
        if (path == null) {
            path = "";
        }
        if ((pathInfo = pRequest.getPathInfo()) != null) {
            path = path + pathInfo;
        }
        return path;
    }

    public static String getFileName(HttpServletRequest pRequest) {
        String path = AbstractEsiFilter.calculatePath(pRequest);
        if (path == null) {
            return null;
        }
        if (!path.contains("/")) {
            return null;
        }
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public String getPath() {
        return this.mPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathElement {
        private String mName;
        private final Map<String, String> mParameters;

        public PathElement(String pDirectoryName) {
            HashMap<String, String> set = new HashMap<String, String>();
            for (String part : pDirectoryName.split(",")) {
                if (this.mName == null) {
                    this.mName = part;
                    continue;
                }
                if (!part.contains("=")) {
                    if (set.containsKey("")) {
                        throw new RuntimeException("Max 1 anonymous parameter");
                    }
                    set.put("", part);
                    set.put(part, "");
                    continue;
                }
                String key = part.substring(0, part.indexOf("="));
                if (key.equals("")) continue;
                String value = part.substring(part.indexOf("=") + 1);
                set.put(key, value);
            }
            this.mParameters = Collections.unmodifiableMap(set);
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String pName) {
            this.mName = pName;
        }

        public Map<String, String> getParameters() {
            return this.mParameters;
        }

        public String toString() {
            return this.getName() + "," + this.mParameters;
        }
    }
}

