/*
 * Decompiled with CFR 0.152.
 */
package org.escenic.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.escenic.http.RandomRepresentation;
import org.escenic.http.Representation;

public class SimpleRepresentation
implements Representation {
    private static final Map<String, Representation> FILES = new HashMap<String, Representation>();
    private byte[] mBytes;
    private long mLastModified;
    private int mVersion;
    private String mContentType;
    private int mHitCount;

    public void accept(InputStream pInputStream) throws IOException {
        int b;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        while ((b = pInputStream.read()) != -1) {
            baos.write(b);
        }
        this.mBytes = baos.toByteArray();
        this.mLastModified = System.currentTimeMillis() / 1000L * 1000L;
        ++this.mVersion;
    }

    public static Representation get(String pFileName) {
        if ("random".equals(pFileName)) {
            return RandomRepresentation.sInstance;
        }
        return FILES.get(pFileName);
    }

    public static void put(String pFileName, Representation pRepresentation) {
        FILES.put(pFileName, pRepresentation);
    }

    public static void remove(String pFileName) {
        FILES.remove(pFileName);
    }

    public byte[] toByteArray() {
        return (byte[])this.mBytes.clone();
    }

    public long getLastModified() {
        return this.mLastModified;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public String toString() {
        return (this.mBytes == null ? "no mBytes" : this.mBytes.length + " bytes") + " version#" + this.mVersion + " from " + new Date(this.mLastModified);
    }

    public String getContentType() {
        return this.mContentType;
    }

    public void setContentType(String pContentType) {
        this.mContentType = pContentType;
    }

    public String getVersionString() {
        return Long.toHexString(new String(this.mBytes).hashCode());
    }

    public int getHitCount() {
        return this.mHitCount;
    }

    public synchronized void hit() {
        ++this.mHitCount;
    }
}

