/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.util.Objects;
import java.util.Properties;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.DefaultAuthenticator;
import org.codehaus.httpcache4j.auth.DefaultProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.resolver.ConnectionConfiguration;
import org.codehaus.httpcache4j.util.PropertiesLoader;

public final class ResolverConfiguration {
    public static final String DEFAULT_USER_AGENT = "HTTPCache4j " + ResolverConfiguration.getVersionFromProperties();
    private final String userAgent;
    private final boolean useChunked;
    private final ProxyAuthenticator proxyAuthenticator;
    private final Authenticator authenticator;
    private final ConnectionConfiguration connectionConfiguration;

    private static String getVersionFromProperties() {
        Properties properties = PropertiesLoader.get(ResolverConfiguration.class.getResourceAsStream("/version.properties"));
        String version = properties.getProperty("version");
        if (Objects.toString(version, "").isEmpty() || version.contains("${")) {
            return "Development";
        }
        return version;
    }

    public ResolverConfiguration(String userAgent, boolean useChunked, ProxyAuthenticator proxyAuthenticator, Authenticator authenticator, ConnectionConfiguration connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
        this.userAgent = Objects.requireNonNull(userAgent, "User Agent may not be null");
        this.useChunked = useChunked;
        this.proxyAuthenticator = Objects.requireNonNull(proxyAuthenticator, "Proxy Authenticator may not be null");
        this.authenticator = Objects.requireNonNull(authenticator, "Authenticator may not be null");
    }

    public ResolverConfiguration(ProxyAuthenticator proxyAuthenticator, Authenticator authenticator, ConnectionConfiguration connectionConfiguration) {
        this(DEFAULT_USER_AGENT, false, proxyAuthenticator, authenticator, connectionConfiguration);
    }

    public ResolverConfiguration() {
        this(DEFAULT_USER_AGENT, false, new DefaultProxyAuthenticator(), new DefaultAuthenticator(), new ConnectionConfiguration());
    }

    public ResolverConfiguration(String userAgent, boolean useChunked) {
        this(userAgent, useChunked, new DefaultProxyAuthenticator(), new DefaultAuthenticator(), new ConnectionConfiguration());
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isUseChunked() {
        return this.useChunked;
    }

    public ProxyAuthenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public ResolverConfiguration withConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
        return new ResolverConfiguration(this.userAgent, this.useChunked, this.proxyAuthenticator, this.authenticator, connectionConfiguration);
    }

    public ResolverConfiguration withAuthenticator(Authenticator authenticator) {
        return new ResolverConfiguration(this.userAgent, this.useChunked, this.proxyAuthenticator, authenticator, this.connectionConfiguration);
    }

    public ResolverConfiguration withProxyAuthenticator(ProxyAuthenticator proxyAuthenticator) {
        return new ResolverConfiguration(this.userAgent, this.useChunked, proxyAuthenticator, this.authenticator, this.connectionConfiguration);
    }

    public ResolverConfiguration withUserAgent(String userAgent) {
        return new ResolverConfiguration(userAgent, this.useChunked, this.proxyAuthenticator, this.authenticator, this.connectionConfiguration);
    }

    public ResolverConfiguration withUserAgent(boolean useChunked) {
        return new ResolverConfiguration(this.userAgent, useChunked, this.proxyAuthenticator, this.authenticator, this.connectionConfiguration);
    }
}

