/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.io.IOException;
import java.util.Objects;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.resolver.ResolverConfiguration;
import org.codehaus.httpcache4j.resolver.ResponseResolver;

public abstract class AbstractResponseResolver
implements ResponseResolver {
    private final ResolverConfiguration configuration;

    protected AbstractResponseResolver(ResolverConfiguration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "Configuration may not be null");
    }

    protected final ProxyAuthenticator getProxyAuthenticator() {
        return this.configuration.getProxyAuthenticator();
    }

    protected final Authenticator getAuthenticator() {
        return this.configuration.getAuthenticator();
    }

    protected final ResolverConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public final HTTPResponse resolve(HTTPRequest request) throws IOException {
        return this.resolveAuthenticated(request);
    }

    private HTTPResponse resolveAuthenticated(HTTPRequest request) throws IOException {
        HTTPResponse convertedResponse;
        HTTPRequest req = request;
        if (this.getAuthenticator().canAuthenticatePreemptively(request)) {
            req = this.getAuthenticator().preparePreemptiveAuthentication(request);
        }
        if (this.getProxyAuthenticator().canAuthenticatePreemptively()) {
            req = this.getProxyAuthenticator().preparePreemptiveAuthentication(req);
        }
        if ((convertedResponse = this.resolveImpl(req)).getStatus() == Status.PROXY_AUTHENTICATION_REQUIRED) {
            return this.resolveProxy(req, convertedResponse);
        }
        if (convertedResponse.getStatus() == Status.UNAUTHORIZED) {
            return this.resolveUnauthorized(req, convertedResponse);
        }
        return convertedResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HTTPResponse resolveProxy(HTTPRequest request, HTTPResponse response) throws IOException {
        HTTPRequest req = this.getProxyAuthenticator().prepareAuthentication(request, response);
        if (req != request) {
            response.consume();
            HTTPResponse newResponse = null;
            try {
                HTTPResponse hTTPResponse = newResponse = this.resolveImpl(req);
                return hTTPResponse;
            }
            finally {
                if (newResponse != null) {
                    if (newResponse.getStatus() == Status.PROXY_AUTHENTICATION_REQUIRED) {
                        this.getProxyAuthenticator().afterFailedAuthentication(newResponse.getHeaders());
                    } else {
                        this.getProxyAuthenticator().afterSuccessfulAuthentication(newResponse.getHeaders());
                    }
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HTTPResponse resolveUnauthorized(HTTPRequest request, HTTPResponse response) throws IOException {
        HTTPRequest req = this.getAuthenticator().prepareAuthentication(request, response);
        if (req != request) {
            response.consume();
            HTTPResponse newResponse = null;
            try {
                HTTPResponse hTTPResponse = newResponse = this.resolveImpl(req);
                return hTTPResponse;
            }
            finally {
                if (newResponse != null) {
                    if (newResponse.getStatus() == Status.UNAUTHORIZED) {
                        this.getAuthenticator().afterFailedAuthentication(req, newResponse.getHeaders());
                    } else {
                        this.getAuthenticator().afterSuccessfulAuthentication(req, newResponse.getHeaders());
                    }
                }
            }
        }
        return response;
    }

    protected abstract HTTPResponse resolveImpl(HTTPRequest var1) throws IOException;
}

