/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.ByteArrayPayload;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.util.IOUtils;

public final class StringPayload
implements Payload,
Serializable {
    private final ByteArrayPayload delegate;
    private final String value;
    private final Charset charset;

    public StringPayload(String value, MIMEType mimeType) {
        this(value, mimeType, StandardCharsets.UTF_8);
    }

    public StringPayload(String value, MIMEType mimeType, Charset charset) {
        this.delegate = new ByteArrayPayload(value.getBytes(charset), mimeType);
        this.value = value;
        this.charset = charset;
    }

    public static StringPayload fromInputStream(InputStream is, MIMEType mime, Charset charset) throws IOException {
        try (InputStream i = is;){
            StringPayload stringPayload = new StringPayload(new String(IOUtils.toByteArray(i), charset), mime, charset);
            return stringPayload;
        }
    }

    public static StringPayload fromInputStream(InputStream is, MIMEType mime) throws IOException {
        return StringPayload.fromInputStream(is, mime, StandardCharsets.UTF_8);
    }

    public String getValue() {
        return this.value;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public MIMEType getMimeType() {
        return this.delegate.getMimeType();
    }

    @Override
    public InputStream getInputStream() {
        return this.delegate.getInputStream();
    }

    @Override
    public long length() {
        return this.delegate.length();
    }

    @Override
    public boolean isAvailable() {
        return this.delegate.isAvailable();
    }
}

