/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.util.IOUtils;

public final class ByteArrayPayload
implements Payload,
Serializable {
    private static final long serialVersionUID = -4845254892809632007L;
    private final byte[] bytes;
    private final MIMEType type;
    private final long length;

    public ByteArrayPayload(InputStream stream, MIMEType type) throws IOException {
        try (InputStream is = stream;){
            this.bytes = IOUtils.toByteArray(is);
        }
        this.length = this.bytes.length;
        this.type = type;
    }

    public ByteArrayPayload(byte[] bytes, MIMEType type) {
        this.bytes = Objects.requireNonNull(bytes, "Byte array may not be null");
        this.type = Objects.requireNonNull(type, "MIMEType may not be null");
        this.length = bytes.length;
    }

    @Override
    public MIMEType getMimeType() {
        return this.type;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public boolean isAvailable() {
        return this.bytes != null && this.bytes.length > 0;
    }
}

