/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.codehaus.httpcache4j.AuthDirective;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.QuotedParameter;
import org.codehaus.httpcache4j.UsernamePasswordChallenge;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.digest.Digest;
import org.codehaus.httpcache4j.auth.digest.RequestDigest;

public class DigestAuthenticatorStrategy
implements AuthenticatorStrategy {
    @Override
    public boolean supports(AuthScheme scheme) {
        return "digest".equalsIgnoreCase(scheme.getType());
    }

    @Override
    public HTTPRequest prepare(HTTPRequest request, AuthScheme scheme) {
        return this.prepare(request, request.getChallenge(), scheme, false);
    }

    @Override
    public HTTPRequest prepareWithProxy(HTTPRequest request, Challenge challenge, AuthScheme scheme) {
        return this.prepare(request, challenge, scheme, true);
    }

    @Override
    public AuthScheme afterSuccessfulAuthentication(AuthScheme scheme, Headers headers) {
        return this.afterSuccessfulAuthentication(scheme, headers, false);
    }

    @Override
    public AuthScheme afterSuccessfulProxyAuthentication(AuthScheme scheme, Headers headers) {
        return this.afterSuccessfulAuthentication(scheme, headers, true);
    }

    private HTTPRequest prepare(HTTPRequest request, Challenge challenge, AuthScheme scheme, boolean proxy) {
        Digest digest = new Digest(new HTTPHost(request.getRequestURI()), scheme);
        HTTPRequest req = request;
        if (challenge instanceof UsernamePasswordChallenge) {
            UsernamePasswordChallenge upc = (UsernamePasswordChallenge)challenge;
            RequestDigest requestDigest = RequestDigest.newInstance(upc, req, digest);
            Header authHeader = proxy ? new Header("Proxy-Authorization", requestDigest.toHeaderValue()) : new Header("Authorization", requestDigest.toHeaderValue());
            req = req.addHeader(authHeader);
        }
        return req;
    }

    public AuthScheme afterSuccessfulAuthentication(AuthScheme scheme, Headers headers, boolean proxy) {
        String nextNonce;
        Header header = proxy ? headers.getFirstHeader("Proxy-Authentication-Info") : headers.getFirstHeader("Authentication-Info");
        if (header != null && (nextNonce = header.getDirectives().get("nextnonce")) != null) {
            ArrayList params = Lists.newArrayList(scheme.getDirective().getParameters());
            for (Parameter parameter : scheme.getDirective().getParameters()) {
                if (!"nonce".equals(parameter.getName())) continue;
                params.remove(parameter);
            }
            params.add(new QuotedParameter("nonce", nextNonce));
            return new AuthScheme(new AuthDirective("Digest", null, params));
        }
        return scheme;
    }
}

