/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class Status
implements Comparable<Status> {
    public static Status CONTINUE = new Status(100, "Continue");
    public static Status SWITCHING_PROTOCOLS = new Status(101, "Switching Protocols");
    public static Status OK = new Status(200, "OK");
    public static Status CREATED = new Status(201, "Created");
    public static Status ACCEPTED = new Status(202, "Accepted");
    public static Status NON_AUTHORITATIVE_INFORMATION = new Status(203, "Non-Authoritative Information");
    public static Status NO_CONTENT = new Status(204, "No Content");
    public static Status RESET_CONTENT = new Status(205, "Reset Content");
    public static Status PARTIAL_CONTENT = new Status(206, "Partial Content");
    public static Status MULTIPLE_CHOICES = new Status(300, "Multiple Choices");
    public static Status MOVED_PERMANENTLY = new Status(301, "Moved Permanently");
    public static Status FOUND = new Status(302, "Found");
    public static Status SEE_OTHER = new Status(303, "See Other");
    public static Status NOT_MODIFIED = new Status(304, "Not Modified");
    public static Status USE_PROXY = new Status(305, "Use Proxy");
    public static Status TEMPORARY_REDIRECT = new Status(307, "Temporary Redirect");
    public static Status BAD_REQUEST = new Status(400, "Bad Request");
    public static Status UNAUTHORIZED = new Status(401, "Unauthorized");
    public static Status PAYMENT_REQUIRED = new Status(402, "Payment Required");
    public static Status FORBIDDEN = new Status(403, "Forbidden");
    public static Status NOT_FOUND = new Status(404, "Not Found");
    public static Status METHOD_NOT_ALLOWED = new Status(405, "Method Not Allowed");
    public static Status NOT_ACCEPTABLE = new Status(406, "Not Acceptable");
    public static Status PROXY_AUTHENTICATION_REQUIRED = new Status(407, "Proxy Authentication Required");
    public static Status REQUEST_TIMEOUT = new Status(408, "Request Timeout");
    public static Status CONFLICT = new Status(409, "Conflict");
    public static Status GONE = new Status(410, "Gone");
    public static Status LENGTH_REQUIRED = new Status(411, "Length Required");
    public static Status PRECONDITION_FAILED = new Status(412, "Precondition Failed");
    public static Status REQUEST_ENTITY_TOO_LARGE = new Status(413, "Request Entity Too Large");
    public static Status REQUEST_URI_TOO_LONG = new Status(414, "Request-URI Too Long");
    public static Status UNSUPPORTED_MEDIA_TYPE = new Status(415, "Unsupported Media Type");
    public static Status REQUESTED_RANGE_NOT_SATISFIABLE = new Status(416, "Requested Range Not Satisfiable");
    public static Status EXPECTATION_FAILED = new Status(417, "Expectation Failed");
    public static Status INTERNAL_SERVER_ERROR = new Status(500, "Internal Server Error");
    public static Status NOT_IMPLEMENTED = new Status(501, "Not Implemented");
    public static Status BAD_GATEWAY = new Status(502, "Bad Gateway");
    public static Status SERVICE_UNAVAILABLE = new Status(503, "Service Unavailable");
    public static Status GATEWAY_TIMEOUT = new Status(504, "Gateway Timeout");
    public static Status HTTP_VERSION_NOT_SUPPORTED = new Status(505, "HTTP Version Not Supported");
    private static final Set<Status> STATUSES_WITHOUT_BODY = ImmutableSet.of((Object)RESET_CONTENT, (Object)NO_CONTENT, (Object)NOT_MODIFIED);
    private static final Map<Integer, Status> STATUSES;
    private final int code;
    private final String name;

    public Status(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Category getCategory() {
        return Category.valueOf(this);
    }

    public boolean isClientError() {
        return Category.CLIENT_ERROR.contains(this);
    }

    public boolean isServerError() {
        return Category.SERVER_ERROR.contains(this);
    }

    public boolean isBodyContentAllowed() {
        return !STATUSES_WITHOUT_BODY.contains(this);
    }

    @Override
    public int compareTo(Status o) {
        if (this.code > o.code) {
            return 1;
        }
        if (this.code == o.code) {
            return 0;
        }
        return -1;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status status = (Status)o;
        if (this.code != status.code) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(status.name) : status.name != null);
    }

    public final int hashCode() {
        int result = this.code;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getCode() + " " + this.getName();
    }

    public static Status valueOf(int statusCode) {
        Status status = STATUSES.get(statusCode);
        if (status != null) {
            return status;
        }
        return new Status(statusCode, "Unknown");
    }

    public static Status[] values() {
        Collection<Status> values = STATUSES.values();
        return values.toArray(new Status[values.size()]);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)CONTINUE.getCode(), (Object)CONTINUE);
        builder.put((Object)SWITCHING_PROTOCOLS.getCode(), (Object)SWITCHING_PROTOCOLS);
        builder.put((Object)OK.getCode(), (Object)OK);
        builder.put((Object)CREATED.getCode(), (Object)CREATED);
        builder.put((Object)ACCEPTED.getCode(), (Object)ACCEPTED);
        builder.put((Object)NON_AUTHORITATIVE_INFORMATION.getCode(), (Object)NON_AUTHORITATIVE_INFORMATION);
        builder.put((Object)NO_CONTENT.getCode(), (Object)NO_CONTENT);
        builder.put((Object)RESET_CONTENT.getCode(), (Object)RESET_CONTENT);
        builder.put((Object)PARTIAL_CONTENT.getCode(), (Object)PARTIAL_CONTENT);
        builder.put((Object)MULTIPLE_CHOICES.getCode(), (Object)MULTIPLE_CHOICES);
        builder.put((Object)MOVED_PERMANENTLY.getCode(), (Object)MOVED_PERMANENTLY);
        builder.put((Object)FOUND.getCode(), (Object)FOUND);
        builder.put((Object)SEE_OTHER.getCode(), (Object)SEE_OTHER);
        builder.put((Object)NOT_MODIFIED.getCode(), (Object)NOT_MODIFIED);
        builder.put((Object)USE_PROXY.getCode(), (Object)USE_PROXY);
        builder.put((Object)TEMPORARY_REDIRECT.getCode(), (Object)TEMPORARY_REDIRECT);
        builder.put((Object)BAD_REQUEST.getCode(), (Object)BAD_REQUEST);
        builder.put((Object)UNAUTHORIZED.getCode(), (Object)UNAUTHORIZED);
        builder.put((Object)PAYMENT_REQUIRED.getCode(), (Object)PAYMENT_REQUIRED);
        builder.put((Object)FORBIDDEN.getCode(), (Object)FORBIDDEN);
        builder.put((Object)NOT_FOUND.getCode(), (Object)NOT_FOUND);
        builder.put((Object)METHOD_NOT_ALLOWED.getCode(), (Object)METHOD_NOT_ALLOWED);
        builder.put((Object)NOT_ACCEPTABLE.getCode(), (Object)NOT_ACCEPTABLE);
        builder.put((Object)PROXY_AUTHENTICATION_REQUIRED.getCode(), (Object)PROXY_AUTHENTICATION_REQUIRED);
        builder.put((Object)REQUEST_TIMEOUT.getCode(), (Object)REQUEST_TIMEOUT);
        builder.put((Object)CONFLICT.getCode(), (Object)CONFLICT);
        builder.put((Object)GONE.getCode(), (Object)GONE);
        builder.put((Object)LENGTH_REQUIRED.getCode(), (Object)LENGTH_REQUIRED);
        builder.put((Object)PRECONDITION_FAILED.getCode(), (Object)PRECONDITION_FAILED);
        builder.put((Object)REQUEST_ENTITY_TOO_LARGE.getCode(), (Object)REQUEST_ENTITY_TOO_LARGE);
        builder.put((Object)REQUEST_URI_TOO_LONG.getCode(), (Object)REQUEST_URI_TOO_LONG);
        builder.put((Object)UNSUPPORTED_MEDIA_TYPE.getCode(), (Object)UNSUPPORTED_MEDIA_TYPE);
        builder.put((Object)REQUESTED_RANGE_NOT_SATISFIABLE.getCode(), (Object)REQUESTED_RANGE_NOT_SATISFIABLE);
        builder.put((Object)EXPECTATION_FAILED.getCode(), (Object)EXPECTATION_FAILED);
        builder.put((Object)INTERNAL_SERVER_ERROR.getCode(), (Object)INTERNAL_SERVER_ERROR);
        builder.put((Object)NOT_IMPLEMENTED.getCode(), (Object)NOT_IMPLEMENTED);
        builder.put((Object)BAD_GATEWAY.getCode(), (Object)BAD_GATEWAY);
        builder.put((Object)SERVICE_UNAVAILABLE.getCode(), (Object)SERVICE_UNAVAILABLE);
        builder.put((Object)GATEWAY_TIMEOUT.getCode(), (Object)GATEWAY_TIMEOUT);
        builder.put((Object)HTTP_VERSION_NOT_SUPPORTED.getCode(), (Object)HTTP_VERSION_NOT_SUPPORTED);
        STATUSES = builder.build();
    }

    public static enum Category {
        INFORMATIONAL(100, 199),
        SUCCESS(200, 299),
        REDIRECTION(300, 399),
        CLIENT_ERROR(400, 499),
        SERVER_ERROR(500, 599);

        private final int min;
        private final int max;

        private Category(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public boolean contains(Status status) {
            return status.getCode() >= this.min && status.getCode() <= this.max;
        }

        public static Category valueOf(Status status) {
            for (Category category : Category.values()) {
                if (!category.contains(status)) continue;
                return category;
            }
            throw new IllegalArgumentException("Unknown category");
        }
    }
}

