/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.io.InputStream;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.payload.InputStreamPayload;
import org.codehaus.httpcache4j.util.NumberUtils;

public final class ResponseCreator {
    public HTTPResponse createResponse(Status status, Headers responseHeaders, InputStream stream) {
        return this.createResponse(new StatusLine(status), responseHeaders, stream);
    }

    public HTTPResponse createResponse(StatusLine line, Headers responseHeaders, InputStream stream) {
        Header contentTypeHeader = responseHeaders.getFirstHeader("Content-Type");
        Header contentLengthHeader = responseHeaders.getFirstHeader("Content-Length");
        MIMEType type = contentTypeHeader != null ? MIMEType.valueOf(contentTypeHeader.getValue()) : MIMEType.APPLICATION_OCTET_STREAM;
        long length = contentLengthHeader != null ? NumberUtils.toLong(contentLengthHeader.getValue(), -1L) : -1L;
        InputStreamPayload payload = null;
        if (line.getStatus().isBodyContentAllowed() && stream != null) {
            payload = new InputStreamPayload(stream, type, length);
        }
        return new HTTPResponse(payload, line, responseHeaders);
    }
}

