/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.Payload;

public class FilePayload
implements Payload {
    private final File file;
    private final MIMEType mimeType;

    public FilePayload(File file, MIMEType mimeType) {
        this.file = (File)Preconditions.checkNotNull((Object)file, (Object)"File may not be null");
        this.mimeType = (MIMEType)Preconditions.checkNotNull((Object)mimeType, (Object)"Mime type may not be null");
    }

    @Override
    public MIMEType getMimeType() {
        return this.mimeType;
    }

    @Override
    public InputStream getInputStream() {
        if (this.isAvailable()) {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new HTTPException(String.format("File %s cannot be read.", this.file.getAbsolutePath()));
    }

    @Override
    public boolean isAvailable() {
        return this.file.exists() && this.file.canRead();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    public File getFile() {
        return this.file;
    }
}

