/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.util.URIDecoder;
import org.codehaus.httpcache4j.util.URIEncoder;
import org.codehaus.httpcache4j.util.URISchemeDefaults;

public final class URIBuilder {
    public static AtomicReference<URISchemeDefaults> schemeDefaults = new AtomicReference<URISchemeDefaults>(new URISchemeDefaults());
    private final String scheme;
    private final String host;
    private final int port;
    private final List<Path> path;
    private final String fragment;
    private final Map<String, List<String>> parameters;
    private final boolean wasPathAbsolute;
    private final boolean endsWithSlash;
    private static Function<String, Path> stringToPath = new Function<String, Path>(){

        public Path apply(String from) {
            return new Path(from);
        }
    };
    private static Function<Path, String> pathToString = new Function<Path, String>(){

        public String apply(Path from) {
            return from.getValue();
        }
    };
    private static Function<Path, String> encodedPathToString = new Function<Path, String>(){

        public String apply(Path from) {
            return from.getEncodedValue();
        }
    };

    private URIBuilder(String scheme, String host, int port, List<Path> path, String fragment, Map<String, List<String>> parameters, boolean wasPathAbsolute, boolean endsWithSlash) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.fragment = fragment;
        this.parameters = parameters;
        this.wasPathAbsolute = wasPathAbsolute;
        this.endsWithSlash = endsWithSlash;
    }

    @Deprecated
    public URIBuilder scheme(String scheme) {
        return this.withScheme(scheme);
    }

    @Deprecated
    public URIBuilder host(String host) {
        return this.withHost(host);
    }

    public URIBuilder withHost(String host) {
        return new URIBuilder(this.scheme, host, this.port, this.path, this.fragment, this.parameters, this.wasPathAbsolute, this.endsWithSlash);
    }

    @Deprecated
    public URIBuilder port(int port) {
        return this.withPort(port);
    }

    public URIBuilder withPort(int port) {
        Optional<Integer> defaultPort = schemeDefaults.get().getPort(this.scheme);
        if (defaultPort.isPresent() && port == (Integer)defaultPort.get()) {
            port = -1;
        }
        return new URIBuilder(this.scheme, this.host, port, this.path, this.fragment, this.parameters, this.wasPathAbsolute, this.endsWithSlash);
    }

    public URIBuilder withScheme(String scheme) {
        return new URIBuilder(scheme, this.host, this.port, this.path, this.fragment, this.parameters, this.wasPathAbsolute, this.endsWithSlash);
    }

    public URIBuilder addRawPath(String path) {
        boolean pathAbsolute = this.wasPathAbsolute || this.path.isEmpty() && path.startsWith("/");
        boolean endsWithSlash = this.endsWithSlash || this.path.isEmpty() && path.endsWith("/");
        List<Path> appendedPath = URIBuilder.toPathParts(path);
        ImmutableList.Builder currentPath = ImmutableList.builder();
        currentPath.addAll(this.path);
        currentPath.addAll(appendedPath);
        return new URIBuilder(this.scheme, this.host, this.port, (List<Path>)currentPath.build(), this.fragment, this.parameters, pathAbsolute, endsWithSlash);
    }

    public URIBuilder addPath(List<String> path) {
        List appendedPath = Lists.transform(path, stringToPath);
        ImmutableList.Builder currentPath = ImmutableList.builder();
        currentPath.addAll(this.path);
        currentPath.addAll((Iterable)appendedPath);
        return new URIBuilder(this.scheme, this.host, this.port, (List<Path>)currentPath.build(), this.fragment, this.parameters, this.wasPathAbsolute, this.endsWithSlash);
    }

    public URIBuilder addPath(String ... path) {
        return this.addPath(Arrays.asList(path));
    }

    @Deprecated
    public URIBuilder path(String ... path) {
        return this.withPath(Arrays.asList(path));
    }

    public URIBuilder withPath(String ... path) {
        return this.withPath(Arrays.asList(path));
    }

    @Deprecated
    public URIBuilder path(List<String> pathList) {
        return this.withPath(pathList);
    }

    public URIBuilder withPath(List<String> pathList) {
        List paths = Lists.transform(pathList, stringToPath);
        return this.pathInternal(paths, false, false);
    }

    @Deprecated
    public URIBuilder rawPath(String path) {
        return this.withRawPath(path);
    }

    public URIBuilder withRawPath(String path) {
        boolean pathAbsoulute = path.startsWith("/");
        boolean endsWithSlash = path.endsWith("/");
        List<Path> parts = URIBuilder.toPathParts(path);
        return this.pathInternal(parts, pathAbsoulute, endsWithSlash);
    }

    private URIBuilder pathInternal(List<Path> pathList, boolean pathAbsolute, boolean endsWithSlash) {
        return new URIBuilder(this.scheme, this.host, this.port, (List<Path>)ImmutableList.copyOf(pathList), this.fragment, this.parameters, pathAbsolute, endsWithSlash);
    }

    @Deprecated
    public URIBuilder fragment(String fragment) {
        return this.withFragment(fragment);
    }

    public URIBuilder withFragment(String fragment) {
        return new URIBuilder(this.scheme, this.host, this.port, this.path, fragment, this.parameters, this.wasPathAbsolute, this.endsWithSlash);
    }

    public URIBuilder noParameters() {
        return this.withParameters(Collections.<Parameter>emptyList());
    }

    @Deprecated
    public URIBuilder parameters(List<Parameter> parameters) {
        return this.withParameters(parameters);
    }

    public URIBuilder withParameters(List<Parameter> parameters) {
        LinkedHashMap<String, List<String>> paraMap = new LinkedHashMap<String, List<String>>();
        for (Parameter parameter : parameters) {
            URIBuilder.addToQueryMap(paraMap, parameter.getName(), parameter.getValue());
        }
        return new URIBuilder(this.scheme, this.host, this.port, this.path, this.fragment, Collections.unmodifiableMap(paraMap), this.wasPathAbsolute, this.endsWithSlash);
    }

    public URIBuilder addParameter(String name, String value) {
        return this.addParameter(new Parameter(name, value));
    }

    public URIBuilder addParameter(Parameter parameter) {
        return this.addParameters(Arrays.asList(parameter));
    }

    public URIBuilder addParameters(List<Parameter> parameters) {
        LinkedHashMap<String, List<String>> paraMap = new LinkedHashMap<String, List<String>>(this.parameters);
        for (Parameter parameter : parameters) {
            URIBuilder.addToQueryMap(paraMap, parameter.getName(), parameter.getValue());
        }
        return new URIBuilder(this.scheme, this.host, this.port, this.path, this.fragment, Collections.unmodifiableMap(paraMap), this.wasPathAbsolute, this.endsWithSlash);
    }

    public URIBuilder removeParameters(String name) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(this.parameters);
        map.remove(name);
        return new URIBuilder(this.scheme, this.host, this.port, this.path, this.fragment, Collections.unmodifiableMap(map), this.wasPathAbsolute, this.endsWithSlash);
    }

    public URIBuilder replaceParameter(String name, String value) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(this.parameters);
        map.remove(name);
        URIBuilder.addToQueryMap(map, name, value);
        return new URIBuilder(this.scheme, this.host, this.port, this.path, this.fragment, Collections.unmodifiableMap(map), this.wasPathAbsolute, this.endsWithSlash);
    }

    private String toPath(boolean encodepath) {
        if (this.path.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Path pathElement : this.path) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(encodepath ? pathElement.getEncodedValue() : pathElement.getValue());
        }
        if ((this.wasPathAbsolute || this.host != null) && builder.length() > 1 && !"/".equals(builder.substring(0, 1))) {
            builder.insert(0, "/");
        }
        if (this.endsWithSlash) {
            builder.append("/");
        }
        return builder.toString();
    }

    public URI toURI() {
        try {
            return new URI(this.scheme, null, this.host, this.port, this.toPath(true), this.toQuery(false), this.fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public URI toNormalizedURI(boolean encodePath) {
        try {
            return new URI(this.scheme, null, this.host, this.port, this.toPath(encodePath), this.toQuery(true), this.fragment).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public URI toNormalizedURI() {
        return this.toNormalizedURI(false);
    }

    public boolean isRelative() {
        return this.scheme == null && this.host == null;
    }

    public URI toAbsoluteURI() {
        if (this.isRelative()) {
            try {
                String path = this.toPath(true);
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                return new URI(null, null, null, -1, path, this.toQuery(false), this.fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.toURI();
    }

    private String toQuery(boolean sort) {
        StringBuilder builder = new StringBuilder();
        List<Parameter> params = this.getParametersAsList();
        if (sort) {
            Collections.sort(params, new Comparator<Parameter>(){

                @Override
                public int compare(Parameter o1, Parameter o2) {
                    return Collator.getInstance(Locale.getDefault()).compare(o1.getName(), o2.getName());
                }
            });
        }
        for (Parameter parameter : params) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(parameter);
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    private List<Parameter> getParametersAsList() {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            for (String value : entry.getValue()) {
                list.add(new Parameter(entry.getKey(), value));
            }
        }
        return list;
    }

    public List<Parameter> getParametersByName(final String name) {
        List<String> params = this.parameters.get(name);
        if (params == null) {
            return Collections.emptyList();
        }
        return Lists.transform(params, (Function)new Function<String, Parameter>(){

            public Parameter apply(String s) {
                return new Parameter(name, s);
            }
        });
    }

    public String getFirstParameterValueByName(String name) {
        List<Parameter> list = this.getParametersByName(name);
        if (!list.isEmpty()) {
            return list.get(0).getValue();
        }
        return null;
    }

    public static URIBuilder fromURI(URI uri) {
        boolean pathAbsoluteness = uri.getPath().startsWith("/");
        boolean endsWithSlash = uri.getPath().endsWith("/");
        return new URIBuilder(uri.getScheme(), uri.getHost(), uri.getPort(), URIBuilder.toPathParts(uri.getPath()), uri.getFragment(), URIBuilder.toQueryMap(uri.getQuery()), pathAbsoluteness, endsWithSlash);
    }

    public static URIBuilder empty() {
        return new URIBuilder(null, null, -1, Collections.<Path>emptyList(), null, Collections.<String, List<String>>emptyMap(), false, false);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public List<String> getPath() {
        return Lists.transform(this.path, pathToString);
    }

    public List<String> getEncodedPath() {
        return Lists.transform(this.path, encodedPathToString);
    }

    public String getCurrentPath() {
        return this.toPath(false);
    }

    public String getFragment() {
        return this.fragment;
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.getParametersAsList());
    }

    public static Map<String, List<String>> toQueryMap(String query) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        if (query != null) {
            Iterable parts = Splitter.on((String)"&").omitEmptyStrings().trimResults().split((CharSequence)query);
            for (String part : parts) {
                String[] equalParts = part.split("=");
                String name = null;
                String value = null;
                if (equalParts.length == 1) {
                    name = equalParts[0];
                } else if (equalParts.length == 2) {
                    name = equalParts[0];
                    value = equalParts[1];
                }
                if (name == null) continue;
                URIBuilder.addToQueryMap(map, URIDecoder.decodeUTF8(name), URIDecoder.decodeUTF8(value));
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private static void addToQueryMap(Map<String, List<String>> map, String name, String value) {
        List<String> list = map.get(name);
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (value != null) {
            list.add(value);
        }
        map.put(name, list);
    }

    private static List<Path> toPathParts(String path) {
        if (path == null) {
            return Collections.emptyList();
        }
        if (!path.contains("/")) {
            return Collections.singletonList(new Path(path));
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        List<String> stringList = Arrays.asList(path.split("/"));
        return ImmutableList.copyOf((Collection)Lists.transform(stringList, stringToPath));
    }

    private static class Path {
        private final String value;

        private Path(String value) {
            this.value = URIDecoder.decodeUTF8(value);
        }

        String getEncodedValue() {
            return URIEncoder.encodeUTF8(this.value);
        }

        String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

