/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.Parameter;

public class LinkDirective
extends Directive {
    private final URI uri;

    public LinkDirective(Directive directive) {
        this(directive.getName(), directive.getParameters());
    }

    public LinkDirective(String name, List<Parameter> parameters) {
        this(URI.create(name), parameters);
    }

    public LinkDirective(URI uri, Iterable<Parameter> parameters) {
        super(uri.toString(), null, Lists.newArrayList(parameters));
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getRel() {
        return this.getParameterValue("rel");
    }

    public String getRev() {
        return this.getParameterValue("rev");
    }

    public String getTitle() {
        return this.getParameterValue("title");
    }

    public URI getAnchor() {
        String paramValue = this.getParameterValue("anchor");
        if (paramValue != null) {
            return URI.create(paramValue);
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder value = new StringBuilder();
        value.append(String.format("<%s>", this.uri));
        for (Parameter parameter : this.getParameters()) {
            if (value.length() > 0) {
                value.append("; ");
            }
            value.append(parameter);
        }
        return value.toString();
    }
}

