/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class PropertiesLoader {
    private PropertiesLoader() {
    }

    public static Properties get(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Closeables.closeQuietly((Closeable)stream);
        }
        return properties;
    }

    public static Properties get(File file) {
        try {
            return PropertiesLoader.get(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

