/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.util.CaseInsensitiveKey;
import org.codehaus.httpcache4j.util.ToJSON;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Headers
implements Iterable<Header>,
ToJSON {
    private final HeaderHashMap headers = new HeaderHashMap();

    public Headers() {
    }

    public Headers(Headers headers) {
        this(headers.copyMap());
    }

    private Headers(HeaderHashMap headers) {
        Validate.notNull((Object)headers, (String)"The header map may not be null");
        this.headers.putAll(headers);
    }

    public List<Header> getHeaders(String headerKey) {
        return this.headers.getAsHeaders(headerKey);
    }

    public Header getFirstHeader(String headerKey) {
        List<Header> headerList = this.getHeaders(headerKey);
        if (!headerList.isEmpty()) {
            return headerList.get(0);
        }
        return null;
    }

    public String getFirstHeaderValue(String headerKey) {
        Header header = this.getFirstHeader(headerKey);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public Headers add(Header header) {
        HeaderHashMap headers = this.copyMap();
        ArrayList<String> list = new ArrayList<String>(headers.get(header.getName()));
        if (!list.contains(header.getValue())) {
            list.add(header.getValue());
        }
        headers.put(header.getName(), (List<String>)list);
        return new Headers(headers);
    }

    public Headers set(Header header) {
        HeaderHashMap headers = this.copyMap();
        headers.put(header.getName(), Lists.newArrayList((Object[])new String[]{header.getValue()}));
        return new Headers(headers);
    }

    public Headers set(String name, String value) {
        return this.set(new Header(name, value));
    }

    public Headers add(String key, String value) {
        return this.add(new Header(key, value));
    }

    public boolean contains(Header header) {
        List<Header> values = this.getHeaders(header.getName());
        return values.contains(header);
    }

    private HeaderHashMap copyMap() {
        return new HeaderHashMap(this.headers);
    }

    @Override
    public Iterator<Header> iterator() {
        return this.headers.headerIterator();
    }

    public Set<String> keySet() {
        return this.headers.keys();
    }

    public boolean hasHeader(String headerName) {
        return !this.headers.get(headerName).isEmpty();
    }

    public Headers add(String name, List<Header> headers) {
        HeaderHashMap heads = this.copyMap();
        heads.putImpl(name, headers);
        return new Headers(heads);
    }

    public Headers remove(String name) {
        HeaderHashMap heads = this.copyMap();
        heads.remove(name);
        return new Headers(heads);
    }

    public Headers add(Iterable<Header> headers) {
        HeaderHashMap map = this.copyMap();
        for (Header header : headers) {
            ArrayList<String> list = new ArrayList<String>(map.get(header.getName()));
            if (!list.contains(header.getValue())) {
                list.add(header.getValue());
            }
            map.put(header.getName(), (List<String>)list);
        }
        return new Headers(map);
    }

    public Headers set(Iterable<Header> headers) {
        HeaderHashMap map = this.copyMap();
        Headers copy = new Headers().add(headers);
        Set<String> keys = copy.keySet();
        for (String key : keys) {
            map.put(key, copy.headers.get(key));
        }
        return new Headers(map);
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Headers headers1 = (Headers)o;
        return this.headers.equals(headers1.headers);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Header header : this) {
            if (builder.length() > 0) {
                builder.append("\r\n");
            }
            builder.append(header);
        }
        return builder.toString();
    }

    public static Headers fromJSON(String value) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            List headers = (List)mapper.readValue(value, TypeFactory.collectionType(List.class, Header.class));
            return new Headers().add(headers);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String toJSON() {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList headers = Lists.newArrayList((Iterable)this);
        try {
            return mapper.writeValueAsString((Object)headers);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HeaderHashMap
    extends LinkedHashMap<CaseInsensitiveKey, List<String>> {
        private static final long serialVersionUID = 2714358409043444835L;
        private static final Function<Header, String> headerToString = new Function<Header, String>(){

            public String apply(Header from) {
                return from.getValue();
            }
        };

        public HeaderHashMap() {
        }

        public HeaderHashMap(HeaderHashMap headerHashMap) {
            super(headerHashMap);
        }

        public List<String> get(String key) {
            return this.get(new CaseInsensitiveKey(key));
        }

        public Set<String> keys() {
            HashSet<String> strings = new HashSet<String>();
            for (CaseInsensitiveKey name : super.keySet()) {
                strings.add(name.getDelegate());
            }
            return strings;
        }

        @Override
        public List<String> get(Object key) {
            List<String> value = (List<String>)super.get(key);
            return value != null ? value : Collections.emptyList();
        }

        List<Header> getAsHeaders(String key) {
            ArrayList headers = new ArrayList();
            CaseInsensitiveKey name = new CaseInsensitiveKey(key);
            headers.addAll(Lists.transform((List)this.get(name), this.nameToHeader(name)));
            return Collections.unmodifiableList(headers);
        }

        private Function<String, Header> nameToHeader(final CaseInsensitiveKey key) {
            return new Function<String, Header>(){

                public Header apply(String from) {
                    return new Header(key.getDelegate(), from);
                }
            };
        }

        @Override
        public List<String> put(String key, List<String> value) {
            return super.put(new CaseInsensitiveKey(key), value);
        }

        List<String> putImpl(String key, List<Header> value) {
            List stringList = Lists.transform(value, headerToString);
            return this.put(key, (List<String>)new ArrayList<String>(stringList));
        }

        public List<String> remove(String key) {
            return (List)this.remove(new CaseInsensitiveKey(key));
        }

        Iterator<Header> headerIterator() {
            ArrayList headers = new ArrayList();
            for (Map.Entry entry : this.entrySet()) {
                headers.addAll(Lists.transform((List)((List)entry.getValue()), this.nameToHeader((CaseInsensitiveKey)entry.getKey())));
            }
            return headers.iterator();
        }
    }
}

