/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.NameValue;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

public final class Header
extends NameValue {
    private Directives directives;

    public Header(String name, String value) {
        super(name, value);
    }

    public Header(String name, Directives directives) {
        super(name, directives.toString());
        this.directives = directives;
    }

    @JsonValue
    public final String toString() {
        return this.getName() + ": " + this.getValue();
    }

    public Directives getDirectives() {
        if (this.directives == null) {
            this.directives = new Directives(this.value);
        }
        return this.directives;
    }

    @JsonCreator
    static Header valueOf(String json) {
        String[] parts = json.split(":", 2);
        if (parts != null) {
            if (parts.length == 1) {
                return new Header(parts[0].trim(), "");
            }
            if (parts.length == 2) {
                return new Header(parts[0].trim(), parts[1].trim());
            }
        }
        throw new IllegalArgumentException("Not a valid header string");
    }
}

