/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.Payload;

public class StringPayload
implements Payload {
    private final String value;
    private final MIMEType mimeType;

    public StringPayload(String value, MIMEType mimeType) {
        Validate.notNull((Object)value, (String)"String value may not be null");
        Validate.notNull((Object)mimeType, (String)"MIMEType may not be null");
        this.value = value;
        this.mimeType = mimeType;
    }

    public MIMEType getMimeType() {
        return this.mimeType;
    }

    public InputStream getInputStream() {
        return IOUtils.toInputStream((String)this.value);
    }

    public boolean isAvailable() {
        return true;
    }
}

