/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth.digest;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.QuotedDirective;
import org.codehaus.httpcache4j.UsernamePasswordChallenge;
import org.codehaus.httpcache4j.auth.digest.Algorithm;
import org.codehaus.httpcache4j.auth.digest.Digest;

public class RequestDigest {
    private static final String CNONCE_COUNT = "00000001";
    private final Map<String, Directive> directives = new LinkedHashMap<String, Directive>();
    private final UsernamePasswordChallenge challenge;
    private final HTTPMethod method;
    private final URI requestURI;
    private final Digest serverDigest;
    private final Algorithm algorithm;

    RequestDigest(UsernamePasswordChallenge challenge, HTTPMethod method, URI requestURI, Digest serverDigest) {
        this.challenge = challenge;
        this.method = method;
        this.requestURI = requestURI;
        this.serverDigest = serverDigest;
        this.addDirective("username", challenge.getIdentifier(), true);
        this.addDirective("realm", serverDigest.getScheme().getRealm(), true);
        this.addDirective("nonce", serverDigest.getNonce(), true);
        this.addDirective("uri", requestURI.toString(), true);
        if (serverDigest.getAlgorithm() != null) {
            this.addDirective("algorithm", serverDigest.getAlgorithm().getValue(), true);
            this.algorithm = serverDigest.getAlgorithm();
        } else {
            this.algorithm = Algorithm.MD5;
        }
        if (StringUtils.isNotBlank((String)serverDigest.getQop())) {
            this.addDirective("qop", serverDigest.getQop(), false);
            this.addDirective("nc", CNONCE_COUNT, false);
            this.addDirective("cnonce", this.calculateCNonce(), true);
        }
        this.addDirective("response", this.calculateResponse(), true);
        if (StringUtils.isNotBlank((String)serverDigest.getOpaque())) {
            this.addDirective("opaque", serverDigest.getOpaque(), true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String calculateResponse() {
        String ha1 = this.calculateHashA1();
        Directive qopDirective = this.directives.get("qop");
        Directive nonce = this.directives.get("nonce");
        String ha2 = this.calculateHashA2();
        if (qopDirective == null) return this.hash(this.algorithm, String.format("%s:%s:%s", ha1, nonce.getValue(), ha2), "US-ASCII");
        if (this.isAuthIntQualityOfProtection(qopDirective)) {
            throw new IllegalArgumentException("Auth-int not supported yet");
        }
        if (!this.isAuthQualityOfProtection(qopDirective)) throw new IllegalArgumentException("Unknown QOP: " + qopDirective.getValue());
        Directive clientNonce = this.directives.get("cnonce");
        StringBuilder builder = new StringBuilder();
        builder.append(ha1);
        builder.append(':');
        builder.append(nonce.getValue());
        builder.append(':');
        builder.append(CNONCE_COUNT);
        builder.append(':');
        builder.append(clientNonce.getValue());
        builder.append(':');
        builder.append(qopDirective.getValue());
        builder.append(':');
        builder.append(ha2);
        return this.hash(this.algorithm, builder.toString(), "ISO-8859-1");
    }

    String calculateHashA2() {
        return this.hash(this.algorithm, String.format("%s:%s", new Object[]{this.method, this.requestURI}), "ISO-8859-1");
    }

    String calculateHashA1() {
        StringBuilder a1 = new StringBuilder();
        a1.append(this.challenge.getIdentifier());
        a1.append(':');
        a1.append(this.serverDigest.getScheme().getRealm());
        a1.append(':');
        a1.append(this.challenge.getPassword());
        return this.hash(this.algorithm, a1.toString(), "US-ASCII");
    }

    private boolean isAuthQualityOfProtection(Directive directive) {
        return "auth".equals(directive.getValue());
    }

    private boolean isAuthIntQualityOfProtection(Directive directive) {
        return "auth-int".equals(directive.getValue());
    }

    private String hash(Algorithm algorithm, String input, String charset) {
        switch (algorithm) {
            case MD5: 
            case MD5_SESSION: {
                try {
                    return DigestUtils.md5Hex((byte[])input.getBytes(charset));
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error(e);
                }
            }
        }
        throw new IllegalArgumentException("No such algorithm");
    }

    String calculateCNonce() {
        return this.hash(Algorithm.MD5, Long.toString(System.currentTimeMillis()), "US-ASCII");
    }

    public String toHeaderValue() {
        StringBuilder builder = new StringBuilder();
        builder.append("Digest ");
        for (Directive directive : this.directives.values()) {
            if (builder.length() > "Digest ".length()) {
                builder.append(", ");
            }
            builder.append(directive);
        }
        return builder.toString();
    }

    public static RequestDigest newInstance(UsernamePasswordChallenge challenge, HTTPRequest request, Digest digest) {
        return new RequestDigest(challenge, request.getMethod(), URI.create(request.getRequestURI().getPath()), digest);
    }

    private void addDirective(String name, String value, boolean quoted) {
        if (quoted) {
            this.directives.put(name, new QuotedDirective(name, value));
        } else {
            this.directives.put(name, new Directive(name, value));
        }
    }
}

