/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.util.URIDecoder;
import org.codehaus.httpcache4j.util.URIEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URIBuilder {
    private final String scheme;
    private final String host;
    private final int port;
    private final List<Path> path;
    private final String fragment;
    private final Map<String, List<String>> parameters;
    private static Function<String, Path> stringToPath = new Function<String, Path>(){

        public Path apply(String from) {
            return new Path(from);
        }
    };

    private URIBuilder(String scheme, String host, int port, List<Path> path, String fragment, Map<String, List<String>> parameters) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.fragment = fragment;
        this.parameters = parameters;
    }

    public URIBuilder scheme(String scheme) {
        return new URIBuilder(scheme, this.host, this.port, this.path, this.fragment, this.parameters);
    }

    public URIBuilder path(String ... path) {
        List<String> pathList = Arrays.asList(path);
        List paths = Lists.transform(pathList, stringToPath);
        return new URIBuilder(this.scheme, this.host, this.port, (List<Path>)ImmutableList.copyOf((Iterable)paths), this.fragment, this.parameters);
    }

    public URIBuilder host(String host) {
        return new URIBuilder(this.scheme, host, this.port, this.path, this.fragment, this.parameters);
    }

    public URIBuilder port(int port) {
        if ("http".equals(this.scheme) && port == 80) {
            port = -1;
        } else if ("https".equals(this.scheme) && port == 443) {
            port = -1;
        }
        return new URIBuilder(this.scheme, this.host, port, this.path, this.fragment, this.parameters);
    }

    public URIBuilder fragment(String fragment) {
        return new URIBuilder(this.scheme, this.host, this.port, this.path, fragment, this.parameters);
    }

    public URIBuilder noParameters() {
        return this.parameters(Collections.<Parameter>emptyList());
    }

    public URIBuilder parameters(List<Parameter> parameters) {
        LinkedHashMap<String, List<String>> paraMap = new LinkedHashMap<String, List<String>>();
        for (Parameter parameter : parameters) {
            URIBuilder.addToQueryMap(paraMap, parameter.getName(), parameter.getValue());
        }
        return new URIBuilder(this.scheme, this.host, this.port, this.path, this.fragment, Collections.unmodifiableMap(paraMap));
    }

    public URIBuilder addParameter(String name, String value) {
        return this.addParameter(new Parameter(name, value));
    }

    public URIBuilder addParameter(Parameter parameter) {
        LinkedHashMap<String, List<String>> parameters = new LinkedHashMap<String, List<String>>(this.parameters);
        URIBuilder.addToQueryMap(parameters, parameter.getName(), parameter.getValue());
        return new URIBuilder(this.scheme, this.host, this.port, this.path, this.fragment, Collections.unmodifiableMap(parameters));
    }

    private String toPath() {
        if (this.path.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Path pathElement : this.path) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(pathElement.getEncodedString());
        }
        if (this.host != null && builder.length() > 1 && !"/".equals(builder.substring(0, 1))) {
            builder.insert(0, "/");
        }
        return builder.toString();
    }

    public URI toURI() {
        try {
            return new URI(this.scheme, null, this.host, this.port, this.toPath(), this.toQuery(), this.fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isRelative() {
        return this.scheme == null && this.host == null;
    }

    public URI toAbsoluteURI() {
        if (this.isRelative()) {
            try {
                String path = this.toPath();
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                return new URI(null, null, null, -1, path, this.toQuery(), this.fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.toURI();
    }

    private String toQuery() {
        StringBuilder builder = new StringBuilder();
        for (Parameter parameter : this.getParametersAsList()) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(parameter);
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    private List<Parameter> getParametersAsList() {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            for (String value : entry.getValue()) {
                list.add(new Parameter(entry.getKey(), value));
            }
        }
        return list;
    }

    public static URIBuilder fromURI(URI uri) {
        return new URIBuilder(uri.getScheme(), uri.getHost(), uri.getPort(), URIBuilder.toPathParts(uri.getPath()), uri.getFragment(), URIBuilder.toQueryMap(uri.getQuery()));
    }

    public static URIBuilder empty() {
        return new URIBuilder(null, null, -1, Collections.<Path>emptyList(), null, Collections.<String, List<String>>emptyMap());
    }

    private static Map<String, List<String>> toQueryMap(String query) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        if (query != null) {
            String[] parts;
            for (String part : parts = query.split("&")) {
                String[] equalParts = part.split("=");
                String name = null;
                String value = null;
                if (equalParts.length == 1) {
                    name = equalParts[0];
                } else if (equalParts.length == 2) {
                    name = equalParts[0];
                    value = equalParts[1];
                }
                if (name == null) continue;
                URIBuilder.addToQueryMap(map, URIDecoder.decodeUTF8(name), URIDecoder.decodeUTF8(value));
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private static void addToQueryMap(Map<String, List<String>> map, String name, String value) {
        List<String> list = map.get(name);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(value);
        map.put(name, list);
    }

    private static List<Path> toPathParts(String path) {
        if (path == null) {
            return Collections.emptyList();
        }
        if (!path.contains("/")) {
            return Collections.singletonList(new Path(path));
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        List<String> stringList = Arrays.asList(path.split("/"));
        return ImmutableList.copyOf((Iterable)Lists.transform(stringList, stringToPath));
    }

    private static class Path {
        private final String value;

        private Path(String value) {
            this.value = URIDecoder.decodeUTF8(value);
        }

        String getEncodedString() {
            return URIEncoder.encodeUTF8(this.value);
        }

        String getValue() {
            return this.value;
        }
    }
}

