/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.resolver.ResponseCreator;
import org.codehaus.httpcache4j.resolver.ResponseResolver;

public abstract class AbstractResponseResolver
implements ResponseResolver {
    private final ResponseCreator responseCreator = new ResponseCreator();
    private final Authenticator authenticator;
    private final ProxyAuthenticator proxyAuthenticator;
    private boolean preemptiveAuthentication = false;

    protected AbstractResponseResolver(ProxyAuthenticator proxyAuthenticator, Authenticator authenticator) {
        Validate.notNull((Object)proxyAuthenticator, (String)"Proxy Authenticator may not be null");
        Validate.notNull((Object)authenticator, (String)"Authenticator may not be null");
        this.authenticator = authenticator;
        this.proxyAuthenticator = proxyAuthenticator;
    }

    protected final ProxyAuthenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    protected ResponseCreator getResponseCreator() {
        return this.responseCreator;
    }

    protected final Authenticator getAuthenticator() {
        return this.authenticator;
    }

    protected final boolean isPreemptiveAuthenticationEnabled() {
        return this.preemptiveAuthentication;
    }

    protected void disablePreemtiveAuthentication() {
        this.preemptiveAuthentication = true;
    }

    protected void enablePreemptiveAuthentication() {
        this.preemptiveAuthentication = false;
    }
}

