/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public abstract class NameValue
implements Serializable {
    protected String name;
    protected String value;
    private static final long serialVersionUID = 8126643664459915558L;

    public NameValue(String name, String value) {
        Validate.notEmpty((String)name, (String)"You may not have an empty name in a name value combination");
        if (StringUtils.isBlank((String)value)) {
            value = "";
        }
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameValue header = (NameValue)o;
        if (this.name != null ? !this.name.equals(header.name) : header.name != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(header.value) : header.value != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "name: " + this.name + " value: " + this.value;
    }
}

