/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Headers
implements Serializable,
Iterable<Map.Entry<String, List<Header>>> {
    private static final long serialVersionUID = -7175564984758939316L;
    private final Map<String, List<Header>> headers = new HashMap<String, List<Header>>();

    public Headers() {
    }

    public Headers(Headers headers) {
        Validate.notNull((Object)headers, (String)"The headers may not be null");
        this.headers.putAll(headers.getHeadersAsMap());
    }

    public Headers(Map<String, List<Header>> headers) {
        Validate.notNull(headers, (String)"The header map may not be null");
        this.headers.putAll(headers);
    }

    public List<Header> getHeaders(String headerKey) {
        return this.headers.get(headerKey);
    }

    public Header getFirstHeader(String headerKey) {
        List<Header> headerList = this.headers.get(headerKey);
        if (headerList != null && !headerList.isEmpty()) {
            return headerList.get(0);
        }
        return null;
    }

    public String getFirstHeaderValue(String headerKey) {
        Header header = this.getFirstHeader(headerKey);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public void add(Header header) {
        List<Header> list = this.headers.get(header.getName());
        if (list == null) {
            list = new ArrayList<Header>();
            this.headers.put(header.getName(), list);
        }
        if (!list.contains(header)) {
            list.add(header);
        }
    }

    public void add(String key, String value) {
        this.add(new Header(key, value));
    }

    public boolean contains(Header header) {
        List<Header> values = this.headers.get(header.getName());
        return values != null && values.contains(header);
    }

    public Map<String, List<Header>> getHeadersAsMap() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public Iterator<Map.Entry<String, List<Header>>> iterator() {
        return this.getHeadersAsMap().entrySet().iterator();
    }

    public Set<String> keySet() {
        return this.headers.keySet();
    }

    public boolean hasHeader(String headerName) {
        return this.headers.get(headerName) != null;
    }

    public void put(String name, List<Header> headers) {
        this.headers.put(name, headers);
    }

    public void remove(String name) {
        this.headers.remove(name);
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }
}

