/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.InputStreamPayload;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.resolver.PayloadCreator;

public abstract class AbstractPayloadCreator
implements PayloadCreator {
    public final Payload createPayload(URI requestURI, Headers responseHeaders, InputStream stream) {
        MIMEType type;
        boolean cacheable = HeaderUtils.hasCacheableHeaders(responseHeaders);
        Header contentTypeHeader = responseHeaders.getFirstHeader("Content-Type");
        MIMEType mIMEType = type = contentTypeHeader != null ? MIMEType.valueOf(contentTypeHeader.getValue()) : MIMEType.APPLICATION_OCTET_STREAM;
        if (cacheable) {
            try {
                return this.createCachedPayload(requestURI, stream, type);
            }
            catch (IOException e) {
                throw new HTTPException("Unable to create reponse storage", e);
            }
        }
        return new InputStreamPayload(stream, type);
    }

    protected abstract Payload createCachedPayload(URI var1, InputStream var2, MIMEType var3) throws IOException;
}

