/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.Payload;

public class InputStreamPayload
implements Payload {
    private final InputStream stream;
    private final MIMEType mimeType;
    private boolean available = true;

    public InputStreamPayload(InputStream stream, MIMEType mimeType) {
        Validate.notNull((Object)stream, (String)"Inputstream may not be null");
        this.mimeType = mimeType != null ? mimeType : MIMEType.APPLICATION_OCTET_STREAM;
        this.stream = new WrappedInputStream(stream);
    }

    public MIMEType getMimeType() {
        return this.mimeType;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isTransient() {
        return !this.stream.markSupported();
    }

    public InputStream getInputStream() {
        if (this.available) {
            return this.stream;
        }
        return null;
    }

    private class WrappedInputStream
    extends InputStream {
        private InputStream delegate;

        public WrappedInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        public int read() throws IOException {
            if (InputStreamPayload.this.available) {
                InputStreamPayload.this.available = false;
            }
            return this.delegate.read();
        }

        public int read(byte[] b) throws IOException {
            if (InputStreamPayload.this.available) {
                InputStreamPayload.this.available = false;
            }
            return this.delegate.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (InputStreamPayload.this.available) {
                InputStreamPayload.this.available = false;
            }
            return this.delegate.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            if (InputStreamPayload.this.available) {
                InputStreamPayload.this.available = false;
            }
            return this.delegate.skip(n);
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public void reset() throws IOException {
            this.delegate.reset();
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

