/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.Payload;

public class FilePayload
implements Payload {
    protected File file;
    private MIMEType mimeType;

    public FilePayload(File file, MIMEType mimeType) {
        Validate.notNull((Object)file, (String)"File may not be null");
        Validate.notNull((Object)mimeType, (String)"Mime type may not be null");
        this.file = file;
        this.mimeType = mimeType;
    }

    public MIMEType getMimeType() {
        return this.mimeType;
    }

    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean isAvailable() {
        return this.file.exists() && this.file.canRead();
    }

    public boolean isTransient() {
        return false;
    }
}

