/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.Conditionals;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.preference.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPRequest {
    private final URI requestURI;
    private final List<Parameter> parameters;
    private final HTTPMethod method;
    private final Conditionals conditionals;
    private final Preferences preferences;
    private Headers headers;
    private Challenge challenge;
    private Payload payload;

    public HTTPRequest(URI requestURI, HTTPMethod method) {
        this.method = method;
        this.requestURI = requestURI;
        this.headers = new Headers();
        this.parameters = new ArrayList<Parameter>();
        this.conditionals = new Conditionals();
        this.preferences = new Preferences();
        String query = requestURI.getQuery();
        if (query != null) {
            this.parseQuery(query);
        }
    }

    public HTTPRequest(URI requestURI) {
        this(requestURI, HTTPMethod.GET);
    }

    private void parseQuery(String query) {
        String[] parts = query.split("&");
        if (parts.length > 0) {
            for (String part : parts) {
                int equalsIndex = part.indexOf(61);
                if (equalsIndex == -1) continue;
                Parameter param = new Parameter(part.substring(0, equalsIndex), part.substring(equalsIndex + 1));
                this.addParameter(param);
            }
        }
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void addHeader(Header header) {
        Validate.notNull((Object)header, (String)"You may not add a null header");
        this.headers.add(header);
    }

    public void addHeader(String name, String value) {
        Validate.notEmpty((String)name, (String)"You may not add a null header");
        Validate.notNull((Object)value, (String)"You may not add a null header");
        this.headers.add(new Header(name, value));
    }

    public void addParameter(Parameter parameter) {
        if (!this.parameters.contains(parameter)) {
            this.parameters.add(parameter);
        }
    }

    public void addParameter(String name, String value) {
        this.addParameter(new Parameter(name, value));
    }

    public Conditionals getConditionals() {
        return this.conditionals;
    }

    public HTTPMethod getMethod() {
        return this.method;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public Challenge getChallenge() {
        return this.challenge;
    }

    public void setChallenge(Challenge challenge) {
        this.challenge = challenge;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public void setHeaders(Headers headers) {
        Validate.notNull((Object)headers, (String)"You may not set null headers");
        this.headers = headers;
    }

    public boolean hasPayload() {
        return this.payload != null;
    }
}

