/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.ToString;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.AbstractASTTransformUtil;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class ToStringASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = ToString.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode STRINGBUFFER_TYPE = ClassHelper.make(StringBuffer.class);
    private static final ClassNode INVOKER_TYPE = ClassHelper.make(InvokerHelper.class);
    private static final Token ASSIGN = Token.newSymbol(100, -1, -1);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            this.checkNotInterface(cNode, MY_TYPE_NAME);
            boolean includeSuper = this.memberHasValue(anno, "includeSuper", true);
            if (includeSuper && cNode.getSuperClass().getName().equals("java.lang.Object")) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: includeSuper=true but '" + cNode.getName() + "' has no super class.", anno);
            }
            boolean includeNames = this.memberHasValue(anno, "includeNames", true);
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            List<String> excludes = this.tokenize((String)this.getMemberValue(anno, "excludes"));
            ToStringASTTransformation.toStringInit(cNode, new ConstantExpression(includeNames));
            ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes);
        }
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes) {
        boolean hasExistingToString = AbstractASTTransformUtil.hasDeclaredMethod(cNode, "toString", 0);
        if (hasExistingToString && AbstractASTTransformUtil.hasDeclaredMethod(cNode, "_toString", 0)) {
            return;
        }
        BlockStatement body = new BlockStatement();
        VariableExpression result = new VariableExpression("_result");
        ConstructorCallExpression init = new ConstructorCallExpression(STRINGBUFFER_TYPE, MethodCallExpression.NO_ARGUMENTS);
        body.addStatement(new ExpressionStatement(new DeclarationExpression((Expression)result, ASSIGN, (Expression)init)));
        body.addStatement(ToStringASTTransformation.append(result, new ConstantExpression(cNode.getName())));
        body.addStatement(ToStringASTTransformation.append(result, new ConstantExpression("(")));
        boolean first = true;
        List<FieldNode> list = AbstractASTTransformUtil.getInstancePropertyFields(cNode);
        if (includeFields) {
            list.addAll(AbstractASTTransformUtil.getInstanceNonPropertyFields(cNode));
        }
        for (FieldNode fNode : list) {
            if (excludes.contains(fNode.getName()) || fNode.getName().contains("$")) continue;
            first = ToStringASTTransformation.appendPrefix(cNode, body, result, first, fNode.getName());
            body.addStatement(ToStringASTTransformation.append(result, new StaticMethodCallExpression(INVOKER_TYPE, "toString", new VariableExpression(fNode))));
        }
        if (includeSuper) {
            ToStringASTTransformation.appendPrefix(cNode, body, result, first, "super");
            body.addStatement(ToStringASTTransformation.append(result, new MethodCallExpression((Expression)VariableExpression.SUPER_EXPRESSION, "toString", MethodCallExpression.NO_ARGUMENTS)));
        }
        body.addStatement(ToStringASTTransformation.append(result, new ConstantExpression(")")));
        body.addStatement(new ReturnStatement(new MethodCallExpression((Expression)result, "toString", MethodCallExpression.NO_ARGUMENTS)));
        cNode.addMethod(new MethodNode(hasExistingToString ? "_toString" : "toString", hasExistingToString ? 2 : 1, ClassHelper.STRING_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body));
    }

    private static boolean appendPrefix(ClassNode cNode, BlockStatement body, Expression result, boolean first, String name) {
        if (first) {
            first = false;
        } else {
            body.addStatement(ToStringASTTransformation.append(result, new ConstantExpression(", ")));
        }
        body.addStatement(new IfStatement(new BooleanExpression(new VariableExpression(cNode.getField("$print$names"))), ToStringASTTransformation.toStringPropertyName(result, name), new EmptyStatement()));
        return first;
    }

    private static Statement toStringPropertyName(Expression result, String fName) {
        BlockStatement body = new BlockStatement();
        body.addStatement(ToStringASTTransformation.append(result, new ConstantExpression(fName)));
        body.addStatement(ToStringASTTransformation.append(result, new ConstantExpression(":")));
        return body;
    }

    private static ExpressionStatement append(Expression result, Expression expr) {
        return new ExpressionStatement(new MethodCallExpression(result, "append", expr));
    }

    public static void toStringInit(ClassNode cNode, ConstantExpression fieldValue) {
        cNode.addField("$print$names", 4098, ClassHelper.boolean_TYPE, fieldValue);
    }
}

