/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.Position;

public class MethodReferenceSearchRequestor
implements ITypeRequestor {
    private final SearchRequestor requestor;
    private final SearchParticipant participant;
    private final char[] name;
    private final String declaringQualifiedName;
    private final boolean findDeclarations;
    private final boolean findReferences;
    private char[][] parameterQualifications;
    private char[][] parameterSimpleNames;
    private final Set<Position> acceptedPositions = new HashSet<Position>();

    public MethodReferenceSearchRequestor(MethodPattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.requestor = requestor;
        this.participant = participant;
        this.name = (char[])ReflectionUtils.getPrivateField(MethodPattern.class, "selector", pattern);
        char[] arr = (char[])ReflectionUtils.getPrivateField(MethodPattern.class, "declaringSimpleName", pattern);
        String declaringSimpleName = arr == null ? "" : new String(arr);
        arr = (char[])ReflectionUtils.getPrivateField(MethodPattern.class, "declaringQualification", pattern);
        String declaringQualification = arr == null || arr.length == 0 ? "" : String.valueOf(new String(arr)) + ".";
        this.declaringQualifiedName = String.valueOf(declaringQualification) + declaringSimpleName;
        this.findDeclarations = (Boolean)ReflectionUtils.getPrivateField(MethodPattern.class, "findDeclarations", pattern);
        this.findReferences = (Boolean)ReflectionUtils.getPrivateField(MethodPattern.class, "findReferences", pattern);
        this.parameterQualifications = pattern.parameterQualifications;
        this.parameterSimpleNames = pattern.parameterSimpleNames;
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        boolean isCompleteMatch;
        Position position;
        StaticMethodCallExpression smnode;
        boolean doCheck = false;
        boolean isDeclaration = false;
        boolean isConstructorCall = false;
        int start = 0;
        int end = 0;
        if (node instanceof ConstantExpression) {
            String cName = ((ConstantExpression)node).getText();
            if (cName != null && CharOperation.equals(this.name, cName.toCharArray())) {
                doCheck = true;
                start = node.getStart();
                end = node.getEnd();
            }
        } else if (node instanceof FieldExpression) {
            if (CharOperation.equals(this.name, ((FieldExpression)node).getFieldName().toCharArray())) {
                doCheck = true;
                start = node.getStart();
                end = node.getEnd();
            }
        } else if (node instanceof MethodNode) {
            MethodNode mnode = (MethodNode)node;
            if (CharOperation.equals(this.name, mnode.getName().toCharArray())) {
                doCheck = true;
                isDeclaration = true;
                start = mnode.getNameStart();
                end = mnode.getNameEnd() + 1;
            }
        } else if (node instanceof VariableExpression) {
            VariableExpression vnode = (VariableExpression)node;
            if (CharOperation.equals(this.name, vnode.getName().toCharArray())) {
                doCheck = true;
                start = vnode.getStart();
                end = start + vnode.getName().length();
            }
        } else if (node instanceof StaticMethodCallExpression && CharOperation.equals(this.name, (smnode = (StaticMethodCallExpression)node).getMethod().toCharArray())) {
            doCheck = true;
            start = smnode.getStart();
            end = start + this.name.length;
        }
        if (doCheck && !this.acceptedPositions.contains(position = new Position(start, end - start)) && (isCompleteMatch = this.qualifiedNameMatches(this.removeArray(result.declaringType)))) {
            SearchMatch match = null;
            if (isDeclaration && this.findDeclarations) {
                match = new MethodDeclarationMatch(enclosingElement, this.getAccuracy(result.confidence, isCompleteMatch), start, end - start, this.participant, enclosingElement.getResource());
            } else if (!isDeclaration && this.findReferences) {
                match = new MethodReferenceMatch(enclosingElement, this.getAccuracy(result.confidence, isCompleteMatch), start, end - start, isConstructorCall, false, false, false, this.participant, enclosingElement.getResource());
            }
            if (match != null) {
                try {
                    this.requestor.acceptSearchMatch(match);
                    this.acceptedPositions.add(position);
                }
                catch (CoreException e) {
                    Util.log(e, "Error reporting search match inside of " + enclosingElement + " in resource " + enclosingElement.getResource());
                }
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private boolean qualifiedNameMatches(ClassNode declaringType) {
        if (this.declaringQualifiedName == null || this.declaringQualifiedName.equals("")) {
            return true;
        }
        if (declaringType == null) {
            return false;
        }
        if (declaringType.getName().equals(this.declaringQualifiedName)) {
            return true;
        }
        return this.qualifiedNameMatches(declaringType.getSuperClass());
    }

    private int getAccuracy(TypeLookupResult.TypeConfidence confidence, boolean isCompleteMatch) {
        if (this.shouldAlwaysBeAccurate()) {
            return 0;
        }
        if (!isCompleteMatch) {
            return 1;
        }
        switch (confidence) {
            case EXACT: {
                return 0;
            }
        }
        return 1;
    }

    private boolean shouldAlwaysBeAccurate() {
        return this.requestor.getClass().getPackage().getName().indexOf("refactoring") != -1;
    }

    private ClassNode removeArray(ClassNode declaration) {
        return declaration.getComponentType() != null ? this.removeArray(declaration.getComponentType()) : declaration;
    }
}

