/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.classloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonLockingJarFile
extends JarFile {
    private static final JarEntry NO_MANIFEST = new JarEntry(String.valueOf(NonLockingJarFile.class.getName()) + ".NO_MANIFEST");
    private File file;
    private Long previousLastModified;
    private SoftReference<Map<String, CachedJarEntry>> jarEntryCache;
    private JarEntry manifestJarEntry;
    private SoftReference<Manifest> manifestRef;

    public NonLockingJarFile(String name) throws IOException {
        this(new File(name), true, 1);
    }

    public NonLockingJarFile(String name, boolean verify) throws IOException {
        this(new File(name), verify, 1);
    }

    public NonLockingJarFile(File file) throws IOException {
        this(file, true, 1);
    }

    public NonLockingJarFile(File file, boolean verify) throws IOException {
        this(file, verify, 1);
    }

    public NonLockingJarFile(File file, boolean verify, int mode) throws IOException {
        super(file, verify, mode);
        this.initialize(file, verify, mode);
    }

    protected void initialize(File file, boolean verify, int mode) throws IOException {
        this.file = file;
        this.close();
    }

    protected final File getFile() {
        return this.file;
    }

    protected JarFile reopenJarFile() throws IOException {
        return new JarFile(this.file, false, 1);
    }

    private void clearJarEntryCacheIfFileHasChanged() {
        long lastModified = this.file.lastModified();
        if (this.previousLastModified == null || this.previousLastModified != lastModified) {
            this.previousLastModified = new Long(lastModified);
            this.jarEntryCache = null;
            this.manifestJarEntry = null;
            this.manifestRef = null;
        }
    }

    private Map<String, CachedJarEntry> getJarEntryCache() {
        Map<String, CachedJarEntry> rtn;
        this.clearJarEntryCacheIfFileHasChanged();
        Map<String, CachedJarEntry> map = rtn = this.jarEntryCache == null ? null : this.jarEntryCache.get();
        if (rtn == null) {
            try {
                JarFile jarFile = this.reopenJarFile();
                try {
                    rtn = new LinkedHashMap<String, CachedJarEntry>();
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        rtn.put(entry.getName(), new CachedJarEntry(entry));
                    }
                    this.jarEntryCache = new SoftReference<Map<String, CachedJarEntry>>(rtn);
                }
                finally {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return rtn;
    }

    private byte[] getZipEntryBytes(ZipEntry ze) throws IOException {
        JarFile jarFile = this.reopenJarFile();
        try {
            byte[] byArray = NonLockingJarFile.getBytes(jarFile.getInputStream(ze));
            return byArray;
        }
        finally {
            jarFile.close();
        }
    }

    private static byte[] getBytes(InputStream input) throws IOException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public ZipEntry getEntry(String name) {
        return this.getJarEntry(name);
    }

    @Override
    public JarEntry getJarEntry(String name) {
        CachedJarEntry cachedJarEntry = this.getJarEntryCache().get(name);
        return cachedJarEntry == null ? null : cachedJarEntry.getJarEntry();
    }

    @Override
    public Enumeration<JarEntry> entries() {
        final Enumeration<CachedJarEntry> cacheEnumeration = Collections.enumeration(this.getJarEntryCache().values());
        return new Enumeration<JarEntry>(){

            @Override
            public boolean hasMoreElements() {
                return cacheEnumeration.hasMoreElements();
            }

            @Override
            public JarEntry nextElement() {
                return ((CachedJarEntry)cacheEnumeration.nextElement()).getJarEntry();
            }
        };
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry ze) throws IOException {
        if (ze == null) {
            throw new IllegalArgumentException("The zip entry is required");
        }
        CachedJarEntry cacheEntry = this.getJarEntryCache().get(ze.getName());
        if (cacheEntry == null) {
            throw new IOException("Unable to locate JAR entry with name " + ze.getName());
        }
        return cacheEntry.getInputStream(this);
    }

    private JarEntry getManifestEntry() {
        if (this.manifestJarEntry == null) {
            this.manifestJarEntry = this.getJarEntry("META-INF/MANIFEST.MF");
            if (this.manifestJarEntry == null) {
                for (CachedJarEntry cachedJarEntry : this.getJarEntryCache().values()) {
                    if (!"META-INF/MANIFEST.MF".equals(cachedJarEntry.getJarEntry().getName().toUpperCase(Locale.ENGLISH))) continue;
                    this.manifestJarEntry = cachedJarEntry.getJarEntry();
                    break;
                }
            }
            if (this.manifestJarEntry == null) {
                this.manifestJarEntry = NO_MANIFEST;
            }
        }
        return this.manifestJarEntry == NO_MANIFEST ? null : this.manifestJarEntry;
    }

    @Override
    public Manifest getManifest() throws IOException {
        Manifest manifest;
        this.clearJarEntryCacheIfFileHasChanged();
        Manifest manifest2 = manifest = this.manifestRef != null ? this.manifestRef.get() : null;
        if (manifest == null) {
            JarEntry manEntry = this.getManifestEntry();
            if (manEntry != null) {
                manifest = new Manifest(this.getInputStream(manEntry));
            }
            this.manifestRef = new SoftReference<Manifest>(manifest);
        }
        return manifest;
    }

    private static class CachedJarEntry {
        private JarEntry jarEntry;
        private byte[] inputStreamData;

        public CachedJarEntry(JarEntry jarEntry) {
            this.jarEntry = jarEntry;
        }

        public JarEntry getJarEntry() {
            return this.jarEntry;
        }

        public InputStream getInputStream(NonLockingJarFile file) throws IOException {
            if (this.inputStreamData == null) {
                this.inputStreamData = file.getZipEntryBytes(this.jarEntry);
            }
            return new ByteArrayInputStream(this.inputStreamData);
        }
    }
}

