/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.PlexusContainer;

public class DependencyCalculator {
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;
    private MavenProject mavenProject;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactInstaller installer;
    private PlexusContainer container;

    public DependencyCalculator(ArtifactFactory artifactFactory, ArtifactResolver resolver, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, MavenProject mavenProject, MavenProjectBuilder mavenProjectBuilder, ArtifactInstaller installer, PlexusContainer container) {
        this.artifactFactory = artifactFactory;
        this.resolver = resolver;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
        this.mavenProject = mavenProject;
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.installer = installer;
        this.container = container;
    }

    public Set<File> execute() throws Exception {
        DefaultProfileManager profileManager = new DefaultProfileManager(this.container);
        this.fixupProjectArtifact();
        Artifact art = this.mavenProject.getArtifact();
        Artifact art2 = this.artifactFactory.createArtifactWithClassifier(art.getGroupId() + ".cargodeps", art.getArtifactId(), art.getVersion(), "pom", null);
        this.resolver.resolve(art2, this.remoteRepositories, this.localRepository);
        MavenProject mavenProject = this.mavenProjectBuilder.buildWithDependencies(art2.getFile(), this.localRepository, (ProfileManager)profileManager);
        HashSet<File> filesToAdd = new HashSet<File>();
        for (Object artifact : mavenProject.getArtifacts()) {
            Artifact artdep = (Artifact)artifact;
            if (!artdep.getType().equals("jar")) continue;
            this.resolver.resolve(artdep, this.remoteRepositories, this.localRepository);
            filesToAdd.add(artdep.getFile());
        }
        return filesToAdd;
    }

    protected void fixupProjectArtifact() throws Exception {
        MavenProject mp2 = new MavenProject(this.mavenProject);
        for (Object artifact : mp2.createArtifacts(this.artifactFactory, null, null)) {
            Artifact art = (Artifact)artifact;
            if (!art.getType().equals("war")) continue;
            Artifact art2 = this.artifactFactory.createArtifactWithClassifier(art.getGroupId(), art.getArtifactId(), art.getVersion(), "pom", null);
            this.fixupRepositoryArtifact(art2);
        }
        Model pomFile = mp2.getModel();
        File outFile = File.createTempFile("pom", ".xml");
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write((Writer)new FileWriter(outFile), pomFile);
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        pomFile = pomReader.read((Reader)new FileReader(outFile));
        Artifact art = mp2.getArtifact();
        this.fixModelAndSaveInRepository(art, pomFile);
        outFile.delete();
    }

    protected void fixupRepositoryArtifact(Artifact artifact) throws Exception {
        this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        File artifactFile = artifact.getFile();
        MavenProject mavenProject = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
        for (Object createdArtifact : mavenProject.createArtifacts(this.artifactFactory, null, null)) {
            Artifact art = (Artifact)createdArtifact;
            if (!art.getType().equals("war")) continue;
            Artifact art2 = this.artifactFactory.createArtifactWithClassifier(art.getGroupId(), art.getArtifactId(), art.getVersion(), "pom", null);
            this.fixupRepositoryArtifact(art2);
        }
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model pomFile = pomReader.read((Reader)new FileReader(artifactFile));
        this.fixModelAndSaveInRepository(artifact, pomFile);
    }

    protected void fixModelAndSaveInRepository(Artifact artifact, Model pomFile) throws Exception {
        for (Object dependency : pomFile.getDependencies()) {
            Dependency art = (Dependency)dependency;
            if (!art.getType().equals("war")) continue;
            art.setGroupId(art.getGroupId() + ".cargodeps");
            art.setType("pom");
        }
        pomFile.setPackaging("pom");
        String version = pomFile.getVersion();
        if (version == null) {
            version = pomFile.getParent().getVersion();
        }
        File outFile = File.createTempFile("pom", ".xml");
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write((Writer)new FileWriter(outFile), pomFile);
        Artifact art2 = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId() + ".cargodeps", artifact.getArtifactId(), artifact.getVersion(), "pom", null);
        this.installer.install(outFile, art2, this.localRepository);
        outFile.delete();
    }
}

