/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cloudfoundry.identity.uaa.impl.config.NestedMapPropertySource;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class UaaMapUtils {
    public static Map<String, Object> flatten(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (map == null || map.isEmpty()) {
            return result;
        }
        NestedMapPropertySource properties = new NestedMapPropertySource("map", map);
        for (String property : properties.getPropertyNames()) {
            if (properties.getProperty(property) == null) continue;
            result.put(property, properties.getProperty(property));
        }
        return result;
    }

    public static Map<String, Object> getPropertiesStartingWith(ConfigurableEnvironment aEnv, String aKeyPrefix) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> map = UaaMapUtils.getAllProperties(aEnv);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(aKeyPrefix)) continue;
            result.put(key, entry.getValue());
        }
        return result;
    }

    public static Map<String, Object> getAllProperties(ConfigurableEnvironment aEnv) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        aEnv.getPropertySources().forEach(ps -> UaaMapUtils.addAll(result, UaaMapUtils.getAllProperties(ps)));
        return result;
    }

    public static Map<String, Object> getAllProperties(PropertySource<?> aPropSource) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (aPropSource instanceof CompositePropertySource) {
            CompositePropertySource cps = (CompositePropertySource)aPropSource;
            cps.getPropertySources().forEach(ps -> UaaMapUtils.addAll(result, UaaMapUtils.getAllProperties(ps)));
            return result;
        }
        if (aPropSource instanceof EnumerablePropertySource) {
            EnumerablePropertySource ps2 = (EnumerablePropertySource)aPropSource;
            Arrays.asList(ps2.getPropertyNames()).forEach(key -> result.put((String)key, ps2.getProperty(key)));
            return result;
        }
        return result;
    }

    private static void addAll(Map<String, Object> aBase, Map<String, Object> aToBeAdded) {
        for (Map.Entry<String, Object> entry : aToBeAdded.entrySet()) {
            if (aBase.containsKey(entry.getKey())) continue;
            aBase.put(entry.getKey(), entry.getValue());
        }
    }

    @SafeVarargs
    public static <K, V, E extends Map.Entry<K, V>> Map<K, V> map(E ... entries) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (E entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K extends Comparable<? super K>, V> Map<K, V> sortByKeys(Map<K, V> map) {
        List sortedEntries = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : sortedEntries) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = UaaMapUtils.sortByKeys((Map)value);
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    public static <K extends Comparable<? super K>, V> String prettyPrintYaml(Map<K, V> map) {
        DumperOptions dump = new DumperOptions();
        dump.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dump.setPrettyFlow(true);
        dump.setIndent(2);
        dump.setCanonical(false);
        dump.setExplicitStart(true);
        Yaml yaml = new Yaml(dump);
        return yaml.dump(UaaMapUtils.sortByKeys(map));
    }

    public static Map<String, ?> redactValues(Map<String, ?> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.putAll(map);
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) {
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map bare = (Map)value;
                result.put(key, UaaMapUtils.redactValues(bare));
                continue;
            }
            if (value instanceof String && StringUtils.isEmpty(value)) {
                result.put(key, "");
                continue;
            }
            result.put(key, "<redacted>");
        }
        return result;
    }
}

