/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.oauth.KeyInfo;
import org.cloudfoundry.identity.uaa.oauth.KeyInfoService;
import org.cloudfoundry.identity.uaa.oauth.TokenRevokedException;
import org.cloudfoundry.identity.uaa.oauth.jwt.Jwt;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHelper;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableToken;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableTokenProvisioning;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.util.UaaTokenUtils;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.util.Assert;

public abstract class TokenValidation {
    private static final Log logger = LogFactory.getLog(TokenValidation.class);
    private final Map<String, Object> claims;
    private final Jwt tokenJwt;
    private final String token;
    private final KeyInfoService keyInfoService;

    public static TokenValidation buildAccessTokenValidator(String tokenJwtValue, KeyInfoService keyInfoService) {
        AccessTokenValidation validator = new AccessTokenValidation(tokenJwtValue, keyInfoService);
        validator.checkSignature();
        return validator;
    }

    public static TokenValidation buildRefreshTokenValidator(String tokenJwtValue, KeyInfoService keyInfoService) {
        RefreshTokenValidation refreshTokenValidation = new RefreshTokenValidation(tokenJwtValue, keyInfoService);
        refreshTokenValidation.checkSignature();
        return refreshTokenValidation;
    }

    public static TokenValidation buildIdTokenValidator(String tokenJwtValue, SignatureVerifier verifier, KeyInfoService keyInfoService) {
        IdTokenValidation idTokenValidation = new IdTokenValidation(tokenJwtValue, keyInfoService);
        idTokenValidation.checkSignature(verifier);
        return idTokenValidation;
    }

    abstract ScopeClaimKey scopeClaimKey();

    @NotNull
    List<String> requestedScopes() {
        return this.readScopesFromClaim(this.scopeClaimKey());
    }

    private TokenValidation(String token, KeyInfoService keyInfoService) {
        this.token = token;
        this.claims = UaaTokenUtils.getClaims(token);
        this.tokenJwt = JwtHelper.decode(token);
        this.keyInfoService = keyInfoService;
    }

    private SignatureVerifier fetchSignatureVerifierFromToken(Jwt tokenJwt) {
        String kid = tokenJwt.getHeader().getKid();
        if (kid == null) {
            throw new InvalidTokenException("kid claim not found in JWT token header");
        }
        KeyInfo signingKey = this.keyInfoService.getKey(kid);
        if (signingKey == null) {
            throw new InvalidTokenException(String.format("Token header claim [kid] references unknown signing key : [%s]", kid));
        }
        return signingKey.getVerifier();
    }

    public TokenValidation checkSignature() {
        return this.checkSignature(this.fetchSignatureVerifierFromToken(this.tokenJwt));
    }

    public TokenValidation checkSignature(SignatureVerifier verifier) {
        try {
            this.tokenJwt.verifySignature(verifier);
        }
        catch (RuntimeException ex) {
            logger.debug((Object)"Invalid token (could not verify signature)", (Throwable)ex);
            throw new InvalidTokenException("Could not verify token signature.", (Throwable)new InvalidSignatureException(this.token));
        }
        return this;
    }

    public TokenValidation checkIssuer(String issuer) {
        if (issuer == null) {
            return this;
        }
        if (!this.claims.containsKey("iss")) {
            throw new InvalidTokenException("Token does not bear an ISS claim.", null);
        }
        if (!TokenValidation.equals(issuer, this.claims.get("iss"))) {
            throw new InvalidTokenException("Invalid issuer (" + this.claims.get("iss") + ") for token did not match expected: " + issuer, null);
        }
        return this;
    }

    protected TokenValidation checkExpiry(Instant asOf) {
        if (!this.claims.containsKey("exp")) {
            throw new InvalidTokenException("Token does not bear an EXP claim.", null);
        }
        Object expClaim = this.claims.get("exp");
        try {
            long expiry = ((Integer)expClaim).intValue();
            if (asOf.getEpochSecond() > expiry) {
                throw new InvalidTokenException("Token expired at " + expiry, null);
            }
        }
        catch (ClassCastException ex) {
            throw new InvalidTokenException("Token bears an invalid or unparseable EXP claim.", (Throwable)ex);
        }
        return this;
    }

    public TokenValidation checkExpiry() {
        return this.checkExpiry(Instant.now());
    }

    protected TokenValidation checkUser(Function<String, UaaUser> getUser) {
        UaaUser user;
        String userId;
        if (!UaaTokenUtils.isUserToken(this.claims)) {
            throw new InvalidTokenException("Token is not a user token.", null);
        }
        if (!this.claims.containsKey("user_id")) {
            throw new InvalidTokenException("Token does not bear a USER_ID claim.", null);
        }
        Object userIdClaim = this.claims.get("user_id");
        try {
            userId = (String)userIdClaim;
        }
        catch (ClassCastException ex) {
            throw new InvalidTokenException("Token bears an invalid or unparseable USER_ID claim.", (Throwable)ex);
        }
        if (userId == null) {
            throw new InvalidTokenException("Token has a null USER_ID claim.", null);
        }
        try {
            user = getUser.apply(userId);
            Assert.notNull((Object)user, (String)"[Assertion failed] - this argument is required; it must not be null");
        }
        catch (UsernameNotFoundException ex) {
            throw new InvalidTokenException("Token bears a non-existent user ID: " + userId, (Throwable)ex);
        }
        catch (InvalidTokenException ex) {
            throw ex;
        }
        if (user == null) {
            throw new InvalidTokenException("Found no data for user ID: " + userId, null);
        }
        List<? extends GrantedAuthority> authorities = user.getAuthorities();
        if (authorities == null) {
            throw new InvalidTokenException("Invalid token (all scopes have been revoked)", null);
        }
        List<String> grantedScopes = authorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        this.checkRequestedScopesAreGranted(grantedScopes);
        return this;
    }

    protected TokenValidation checkRequestedScopesAreGranted(String ... grantedScopes) {
        return this.checkRequestedScopesAreGranted(Arrays.asList(grantedScopes));
    }

    protected TokenValidation checkRequestedScopesAreGranted(Collection<String> grantedScopes) {
        List<String> requestedScopes = this.requestedScopes();
        Set grantedScopePatterns = UaaStringUtils.constructWildcards(grantedScopes);
        List missingScopes = requestedScopes.stream().filter(requestedScope -> grantedScopePatterns.stream().noneMatch(grantedScopePattern -> grantedScopePattern.matcher((CharSequence)requestedScope).matches())).collect(Collectors.toList());
        if (!missingScopes.isEmpty()) {
            String scopeClaimKey = this.scopeClaimKey().keyName();
            String message = String.format("Some required \"%s\" are missing: [%s]", scopeClaimKey, String.join((CharSequence)", ", missingScopes));
            throw new InvalidTokenException(message);
        }
        return this;
    }

    public TokenValidation checkClientAndUser(ClientDetails client, UaaUser user) {
        TokenValidation validation = this.checkClient(cid -> {
            if (!TokenValidation.equals(cid, client.getClientId())) {
                throw new InvalidTokenException("Token's client ID does not match expected value: " + client.getClientId());
            }
            return client;
        });
        if (UaaTokenUtils.isUserToken(this.claims)) {
            return validation.checkUser(uid -> {
                if (user == null) {
                    throw new InvalidTokenException("Unable to validate user, no user found.");
                }
                if (!TokenValidation.equals(uid, user.getId())) {
                    throw new InvalidTokenException("Token does not have expected user ID.");
                }
                return user;
            }).checkRequiredUserGroups(Optional.ofNullable((Collection)client.getAdditionalInformation().get("required_user_groups")).orElse(Collections.emptySet()), AuthorityUtils.authorityListToSet(user.getAuthorities()));
        }
        return validation;
    }

    protected TokenValidation checkRequiredUserGroups(Collection<String> requiredGroups, Collection<String> userGroups) {
        if (!UaaTokenUtils.hasRequiredUserGroups(requiredGroups, userGroups)) {
            throw new InvalidTokenException("User does not meet the client's required group criteria.", null);
        }
        return this;
    }

    protected TokenValidation checkClient(Function<String, ClientDetails> getClient) {
        String clientId;
        if (!this.claims.containsKey("cid")) {
            throw new InvalidTokenException("Token bears no client ID.", null);
        }
        if (this.claims.containsKey("client_id") && !TokenValidation.equals(this.claims.get("cid"), this.claims.get("client_id"))) {
            throw new InvalidTokenException("Token bears conflicting client ID claims.", null);
        }
        try {
            clientId = (String)this.claims.get("cid");
        }
        catch (ClassCastException ex) {
            throw new InvalidTokenException("Token bears an invalid or unparseable CID claim.", (Throwable)ex);
        }
        try {
            ClientDetails client = getClient.apply(clientId);
            Collection clientScopes = null == this.claims.get("user_id") ? (Collection)Optional.ofNullable(client.getAuthorities()).map(a -> a.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList())).orElse(Collections.emptyList()) : client.getScope();
            this.checkRequestedScopesAreGranted(clientScopes);
        }
        catch (NoSuchClientException ex) {
            throw new InvalidTokenException("The token refers to a non-existent client: " + clientId, (Throwable)ex);
        }
        catch (InvalidTokenException ex) {
            throw ex;
        }
        return this;
    }

    public TokenValidation checkRevocationSignature(List<String> revocableSignatureList) {
        String revocableHashSignature;
        if (!this.claims.containsKey("rev_sig")) {
            return this;
        }
        try {
            revocableHashSignature = (String)this.claims.get("rev_sig");
        }
        catch (ClassCastException ex) {
            throw new InvalidTokenException("Token bears an invalid or unparseable revocation signature.", (Throwable)ex);
        }
        boolean hashMatched = false;
        for (String revocableSignature : revocableSignatureList) {
            if (!revocableHashSignature.equals(revocableSignature)) continue;
            hashMatched = true;
            break;
        }
        if (revocableHashSignature == null || !hashMatched) {
            throw new TokenRevokedException("revocable signature mismatch");
        }
        return this;
    }

    public TokenValidation checkAudience(String ... clients) {
        return this.checkAudience(Arrays.asList(clients));
    }

    protected TokenValidation checkAudience(Collection<String> clients) {
        List<String> audience;
        if (!this.claims.containsKey("aud")) {
            throw new InvalidTokenException("The token does not bear an AUD claim.", null);
        }
        Object audClaim = this.claims.get("aud");
        if (audClaim instanceof String) {
            audience = Collections.singletonList((String)audClaim);
        } else if (audClaim == null) {
            audience = Collections.emptyList();
        } else {
            try {
                audience = ((List)audClaim).stream().map(s -> (String)s).collect(Collectors.toList());
            }
            catch (ClassCastException ex) {
                throw new InvalidTokenException("The token's audience claim is invalid or unparseable.", (Throwable)ex);
            }
        }
        List notInAudience = clients.stream().filter(c -> !audience.contains(c)).collect(Collectors.toList());
        if (!notInAudience.isEmpty()) {
            String joinedAudiences = notInAudience.stream().map(c -> "".equals(c) ? "EMPTY_VALUE" : c).collect(Collectors.joining(", "));
            throw new InvalidTokenException("Some parties were not in the token audience: " + joinedAudiences, null);
        }
        return this;
    }

    public TokenValidation checkRevocableTokenStore(RevocableTokenProvisioning revocableTokenProvisioning) {
        block6: {
            try {
                if (!this.claims.containsKey("revocable") || !((Boolean)this.claims.get("revocable")).booleanValue()) break block6;
                String tokenId = (String)this.claims.get("jti");
                if (tokenId == null) {
                    throw new InvalidTokenException("The token does not bear a token ID (JTI).", null);
                }
                RevocableToken revocableToken = null;
                try {
                    revocableToken = (RevocableToken)revocableTokenProvisioning.retrieve(tokenId, IdentityZoneHolder.get().getId());
                }
                catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                    // empty catch block
                }
                if (revocableToken == null) {
                    throw new TokenRevokedException("The token has been revoked: " + tokenId);
                }
            }
            catch (ClassCastException ex) {
                throw new InvalidTokenException("The token's revocability or JTI claim is invalid or unparseable.", (Throwable)ex);
            }
        }
        return this;
    }

    private static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private List<String> readScopesFromClaim(ScopeClaimKey scopeClaimKey) {
        String scopeKeyName = scopeClaimKey.keyName();
        if (!this.claims.containsKey(scopeKeyName)) {
            String errorMessage = String.format("The token does not bear a \"%s\" claim.", scopeKeyName);
            logger.error((Object)errorMessage);
            throw new InvalidTokenException(errorMessage);
        }
        Object scopeClaim = this.claims.get(scopeKeyName);
        if (scopeClaim == null) {
            return Lists.newArrayList();
        }
        InvalidTokenException unparsableClaimException = new InvalidTokenException(String.format("The token's \"%s\" claim is invalid or unparseable.", scopeKeyName));
        if (!(scopeClaim instanceof List)) {
            throw unparsableClaimException;
        }
        List scopes = (List)scopeClaim;
        if (scopes.stream().allMatch(String.class::isInstance)) {
            return scopes.stream().map(o -> (String)o).collect(Collectors.toList());
        }
        throw unparsableClaimException;
    }

    public Jwt getJwt() {
        return this.tokenJwt;
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public TokenValidation checkJti() {
        Object jti = this.getClaims().get("jti");
        if (jti == null) {
            throw new InvalidTokenException("The token must contain a jti claim.", null);
        }
        this.validateJtiValue(jti.toString());
        return this;
    }

    protected abstract void validateJtiValue(String var1);

    public ClientDetails getClientDetails(ClientServicesExtension clientDetailsService) {
        String clientId = (String)this.claims.get("cid");
        try {
            return clientDetailsService.loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
        }
        catch (NoSuchClientException x) {
            throw new InvalidTokenException("Invalid client ID " + clientId);
        }
    }

    public UaaUser getUserDetails(UaaUserDatabase userDatabase) {
        String userId = (String)this.claims.get("user_id");
        if (UaaTokenUtils.isUserToken(this.claims)) {
            try {
                return userDatabase.retrieveUserById(userId);
            }
            catch (UsernameNotFoundException e) {
                throw new InvalidTokenException("Token bears a non-existent user ID: " + userId);
            }
        }
        return null;
    }

    static enum ScopeClaimKey {
        SCOPE("scope"),
        GRANTED_SCOPES("granted_scopes");

        private String keyName;

        private ScopeClaimKey(String keyName) {
            this.keyName = keyName;
        }

        String keyName() {
            return this.keyName;
        }
    }

    private static class IdTokenValidation
    extends TokenValidation {
        public IdTokenValidation(String tokenJwtValue, KeyInfoService keyInfoService) {
            super(tokenJwtValue, keyInfoService);
        }

        @Override
        ScopeClaimKey scopeClaimKey() {
            return ScopeClaimKey.SCOPE;
        }

        @Override
        protected void validateJtiValue(String jtiValue) {
            if (jtiValue.endsWith("-r")) {
                throw new InvalidTokenException("Invalid access token.", null);
            }
        }
    }

    private static class RefreshTokenValidation
    extends TokenValidation {
        public RefreshTokenValidation(String tokenJwtValue, KeyInfoService uaaUrl) {
            super(tokenJwtValue, uaaUrl);
        }

        @Override
        protected void validateJtiValue(String jtiValue) {
            if (!jtiValue.endsWith("-r")) {
                throw new InvalidTokenException("Invalid refresh token.", null);
            }
        }

        @Override
        ScopeClaimKey scopeClaimKey() {
            if (this.getClaims().containsKey(ScopeClaimKey.GRANTED_SCOPES.keyName())) {
                return ScopeClaimKey.GRANTED_SCOPES;
            }
            return ScopeClaimKey.SCOPE;
        }
    }

    private static class AccessTokenValidation
    extends TokenValidation {
        public AccessTokenValidation(String tokenJwtValue, KeyInfoService keyInfoService) {
            super(tokenJwtValue, keyInfoService);
        }

        @Override
        protected void validateJtiValue(String jtiValue) {
            if (jtiValue.endsWith("-r")) {
                throw new InvalidTokenException("Invalid access token.", null);
            }
        }

        @Override
        ScopeClaimKey scopeClaimKey() {
            return ScopeClaimKey.SCOPE;
        }
    }
}

