/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class X509ExpiryCheckingTrustManager
implements X509TrustManager {
    private X509TrustManager delegate;

    public X509ExpiryCheckingTrustManager() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            X509TrustManager x509Tm = null;
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                x509Tm = (X509TrustManager)tm;
                break;
            }
            this.delegate = x509Tm;
        }
        catch (KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
    }

    protected void setDelegate(X509TrustManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (this.delegate == null) {
            throw new CertificateException();
        }
        this.delegate.checkClientTrusted(x509Certificates, s);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (this.delegate == null) {
            throw new CertificateException();
        }
        this.delegate.checkServerTrusted(x509Certificates, s);
        for (X509Certificate certificate : x509Certificates) {
            certificate.checkValidity();
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this.delegate != null) {
            return this.delegate.getAcceptedIssuers();
        }
        return new X509Certificate[0];
    }
}

