/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.ldap.extension;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.ldap.extension.DefaultLdapAuthoritiesPopulator;
import org.cloudfoundry.identity.uaa.provider.ldap.extension.LdapAuthority;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.StringUtils;

public class NestedLdapAuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator {
    public static final String MEMBER_OF = "memberOf";
    private static final Log logger = LogFactory.getLog(NestedLdapAuthoritiesPopulator.class);
    private Set<String> attributeNames;
    private int maxSearchDepth = 10;

    public NestedLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        super(contextSource, groupSearchBase);
    }

    @Override
    public Collection<GrantedAuthority> getGrantedAuthorities(DirContextOperations user, String username) {
        if (MEMBER_OF.equals(this.getGroupSearchBase())) {
            String[] memberOfs = user.getStringAttributes(MEMBER_OF);
            if (memberOfs == null || memberOfs.length == 0) {
                return Collections.EMPTY_LIST;
            }
            return Arrays.stream(memberOfs).map(s -> new LdapAuthority((String)s, (String)s)).collect(Collectors.toList());
        }
        return super.getGrantedAuthorities(user, username);
    }

    @Override
    public Set<GrantedAuthority> getGroupMembershipRoles(String userDn, String username) {
        if (this.getGroupSearchBase() == null) {
            return new HashSet<GrantedAuthority>();
        }
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        this.performNestedSearch(userDn, username, authorities, this.getMaxSearchDepth());
        return authorities;
    }

    protected void performNestedSearch(String userDn, String username, Set<GrantedAuthority> authorities, int depth) {
        if (depth == 0) {
            logger.debug((Object)("Search aborted, max depth reached, for roles for user '" + username + "', DN = '" + userDn + "', with filter " + this.getGroupSearchFilter() + " in search base '" + this.getGroupSearchBase() + "'"));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for roles for user '" + username + "', DN = '" + userDn + "', with filter " + this.getGroupSearchFilter() + " in search base '" + this.getGroupSearchBase() + "'"));
        }
        if (StringUtils.hasText((String)this.getGroupRoleAttribute()) && !this.getAttributeNames().contains(this.getGroupRoleAttribute())) {
            this.getAttributeNames().add(this.getGroupRoleAttribute());
        }
        Set<Map<String, String[]>> userRoles = this.getLdapTemplate().searchForMultipleAttributeValues(this.getGroupSearchBase(), this.getGroupSearchFilter(), new String[]{userDn, username}, this.getAttributeNames().toArray(new String[this.getAttributeNames().size()]));
        if (logger.isDebugEnabled()) {
            this.logRoles(userRoles);
        }
        for (Map<String, String[]> record : userRoles) {
            String roleName;
            boolean circular = false;
            String dn = record.get("spring.security.ldap.dn")[0];
            String[] roleValues = record.get(this.getGroupRoleAttribute());
            HashSet<String> roles = new HashSet<String>();
            roles.addAll(Arrays.asList(roleValues != null ? roleValues : new String[]{}));
            for (String role : roles) {
                if (this.isConvertToUpperCase()) {
                    role = role.toUpperCase();
                }
                circular |= !authorities.add(new LdapAuthority(role = this.getRolePrefix() + role, dn, record));
            }
            String string = roleName = roles.size() > 0 ? (String)roles.iterator().next() : dn;
            if (circular) continue;
            this.performNestedSearch(dn, roleName, authorities, depth - 1);
        }
    }

    protected void logRoles(Set<Map<String, String[]>> userRoles) {
        int counter = 0;
        StringBuffer logDebug = new StringBuffer();
        for (Map<String, String[]> debugRoles : userRoles) {
            for (String debugRoleKey : debugRoles.keySet()) {
                logDebug.append(++counter);
                logDebug.append(".[");
                logDebug.append("Key:");
                logDebug.append(debugRoleKey);
                logDebug.append(" Values:");
                for (String debugValues : debugRoles.get(debugRoleKey)) {
                    logDebug.append(debugValues);
                    logDebug.append("; ");
                }
                logDebug.append("] ");
            }
        }
        if (counter > 0) {
            logger.debug((Object)("Roles from LDAP search:" + logDebug));
        } else {
            logger.debug((Object)"No Roles from LDAP search returned");
        }
    }

    public Set<String> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(Set<String> attributeNames) {
        this.attributeNames = attributeNames;
    }

    public int getMaxSearchDepth() {
        return this.maxSearchDepth;
    }

    public void setMaxSearchDepth(int maxSearchDepth) {
        this.maxSearchDepth = maxSearchDepth;
    }
}

