/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.util.UaaTokenUtils;

public class TokenEndpointBuilder {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String issuer;

    public TokenEndpointBuilder(String issuerUrlBase) throws Exception {
        this.setIssuer(issuerUrlBase);
    }

    public String getTokenEndpoint() {
        try {
            return UaaTokenUtils.constructTokenEndpointUrl(this.issuer);
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)("Failed to get token endpoint for issuer " + this.issuer), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) throws Exception {
        new URL(issuer);
        this.issuer = issuer;
    }
}

